/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import network.arkane.provider.clients.TransactionClient;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.ERC1155Contract;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.base.AbiDefinition;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ERC1155ContractClient
extends TransactionClient {
    private static final Logger log = LoggerFactory.getLogger(ERC1155ContractClient.class);

    public static boolean isERC1155Contract(String contractAddress) {
        try {
            byte[] erc1155Bytes = Hex.decode((String)"d9b67a26");
            AbiDefinition abiDefinition = ERC1155Contract.defaultERC1155Contract.findAbiDefinition("supportsInterface");
            ContractCall call = ERC1155Contract.buildCall(abiDefinition, new Object[]{erc1155Bytes});
            return Boolean.valueOf(ERC1155ContractClient.callContract(call, Address.fromHexString(contractAddress), Revision.BEST).getData());
        }
        catch (Exception ex) {
            log.debug("Unable to fetch supportsInterface for {}", (Object)contractAddress);
            return false;
        }
    }
}

