/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.clients;

import java.io.IOException;
import network.arkane.provider.Prefix;
import network.arkane.provider.clients.TransactionClient;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.blockchain.ContractCallResult;
import network.arkane.provider.core.model.blockchain.TransferResult;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.ProtoTypeContract;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.ToClause;
import network.arkane.provider.core.model.clients.base.AbiDefinition;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.utils.crypto.ECKeyPair;

public class ProtoTypeContractClient
extends TransactionClient {
    public static ContractCallResult getMasterAddress(Address target, Revision revision) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("master");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ContractCall call = ProtoTypeContract.buildCall(abi, target.toHexString(Prefix.ZeroLowerX));
        return ProtoTypeContractClient.callContract(call, ProtoTypeContract.ContractAddress, revision);
    }

    public static TransferResult setMasterAddress(Address[] targets, Address[] newMasters, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        if (newMasters == null) {
            throw ClientArgumentException.exception("newMasters in null");
        }
        if (targets.length != newMasters.length) {
            throw ClientArgumentException.exception("targets size must equal to newMasters size. ");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("setMaster");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX), newMasters[index].toHexString(Prefix.ZeroLowerX));
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static TransferResult addUsers(Address[] targets, Address[] users, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        if (users == null) {
            throw ClientArgumentException.exception("users is null");
        }
        if (targets.length != users.length) {
            throw ClientArgumentException.exception("targets size must equal to users size. ");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("addUser");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX), users[index].toHexString(Prefix.ZeroLowerX));
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static TransferResult removeUsers(Address[] targets, Address[] users, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        if (users == null) {
            throw ClientArgumentException.exception("users is null");
        }
        if (targets.length != users.length) {
            throw ClientArgumentException.exception("targets size must equal to users size. ");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("removeUser");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX), users[index].toHexString(Prefix.ZeroLowerX));
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static TransferResult setCreditPlans(Address[] targets, Amount[] credits, Amount[] recoveryRates, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        if (credits == null) {
            throw ClientArgumentException.exception("credits is null");
        }
        if (recoveryRates == null) {
            throw ClientArgumentException.exception("recoveries is null");
        }
        if (targets.length != credits.length || targets.length != recoveryRates.length) {
            throw ClientArgumentException.exception("users.length must equal to credits.length and equal to recoveries.length");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("setCreditPlan");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX), credits[index].toBigInteger(), recoveryRates[index].toBigInteger());
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static ContractCallResult isUser(Address target, Address user, Revision revision) throws IOException {
        if (target == null) {
            throw ClientArgumentException.exception("target address is null");
        }
        if (user == null) {
            throw ClientArgumentException.exception("user address is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("isUser");
        ContractCall call = ProtoTypeContract.buildCall(abi, target.toHexString(Prefix.ZeroLowerX), user.toHexString(Prefix.ZeroLowerX));
        return ProtoTypeContractClient.callContract(call, ProtoTypeContract.ContractAddress, revision);
    }

    public static ContractCallResult getCreditPlan(Address target, Revision revision) throws IOException {
        if (target == null) {
            throw ClientArgumentException.exception("target is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("creditPlan");
        ContractCall call = ProtoTypeContract.buildCall(abi, target.toHexString(Prefix.ZeroLowerX));
        return ProtoTypeContractClient.callContract(call, ProtoTypeContract.ContractAddress, revision);
    }

    public static ContractCallResult getUserCredit(Address target, Address user, Revision revision) throws IOException {
        if (target == null) {
            throw ClientArgumentException.exception("target address is null");
        }
        if (user == null) {
            throw ClientArgumentException.exception("user address is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("userCredit");
        ContractCall call = ProtoTypeContract.buildCall(abi, target.toHexString(Prefix.ZeroLowerX), user.toHexString(Prefix.ZeroLowerX));
        return ProtoTypeContractClient.callContract(call, ProtoTypeContract.ContractAddress, revision);
    }

    public static TransferResult sponsor(Address[] targets, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("sponsor");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX));
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static TransferResult unsponsor(Address[] targets, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("unsponsor");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX));
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static TransferResult selectSponsor(Address[] targets, Address[] sponsors, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (targets == null) {
            throw ClientArgumentException.exception("targets is null");
        }
        if (sponsors == null) {
            throw ClientArgumentException.exception("sponsors is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("selectSponsor");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[targets.length];
        for (int index = 0; index < targets.length; ++index) {
            clauses[index] = ProtoTypeContract.buildToClause(ProtoTypeContract.ContractAddress, abi, targets[index].toHexString(Prefix.ZeroLowerX), sponsors[index].toHexString(Prefix.ZeroLowerX));
        }
        return ProtoTypeContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }

    public static ContractCallResult getCurrentSponsor(Address target, Revision revision) throws IOException {
        if (target == null) {
            throw ClientArgumentException.exception("target is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("currentSponsor");
        ContractCall call = ProtoTypeContract.buildCall(abi, target.toHexString(Prefix.ZeroLowerX));
        return ProtoTypeContractClient.callContract(call, ProtoTypeContract.ContractAddress, revision);
    }

    public static ContractCallResult isSponsor(Address target, Address sponsor, Revision revision) throws IOException {
        if (target == null) {
            throw ClientArgumentException.exception("target is null");
        }
        if (sponsor == null) {
            throw ClientArgumentException.exception("sponsor is null");
        }
        AbiDefinition abi = ProtoTypeContract.defaultContract.findAbiDefinition("isSponsor");
        ContractCall call = ProtoTypeContract.buildCall(abi, target.toHexString(Prefix.ZeroLowerX), sponsor.toHexString(Prefix.ZeroLowerX));
        return ProtoTypeContractClient.callContract(call, ProtoTypeContract.ContractAddress, revision);
    }
}

