/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils.rlp;

import java.math.BigInteger;
import java.util.Arrays;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.utils.rlp.RlpType;

public class RlpString
implements RlpType {
    public static final byte[] EMPTY = new byte[0];
    private final byte[] value;

    private RlpString(byte[] value) {
        this.value = value;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public BigInteger asBigInteger() {
        if (this.value.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.value);
    }

    public String asString() {
        return BytesUtils.toHexString((byte[])this.value, (Prefix)Prefix.ZeroLowerX);
    }

    public static RlpString create(byte[] value) {
        return new RlpString(value);
    }

    public static RlpString create(byte value) {
        return new RlpString(new byte[]{value});
    }

    public static RlpString create(BigInteger value) {
        if (value.signum() < 1) {
            return new RlpString(EMPTY);
        }
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            return new RlpString(Arrays.copyOfRange(bytes, 1, bytes.length));
        }
        return new RlpString(bytes);
    }

    public static RlpString create(long value) {
        return RlpString.create(BigInteger.valueOf(value));
    }

    public static RlpString create(String value) {
        return new RlpString(value.getBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RlpString rlpString = (RlpString)o;
        return Arrays.equals(this.value, rlpString.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

