/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.clients.base;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.util.HashMap;
import network.arkane.provider.Prefix;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.blockchain.ContractCallResult;
import network.arkane.provider.core.model.blockchain.NodeProvider;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.core.model.exception.ClientIOException;
import network.arkane.provider.utils.URLUtils;

public abstract class AbstractClient {
    private static ObjectMapper objectMapper;

    private static String rawUrl(Path path) {
        return NodeProvider.getNodeProvider().getProvider() + path.getPath();
    }

    public static void setTimeout(int timeout) {
        try {
            Unirest.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Unirest.setTimeouts((long)timeout, (long)timeout);
    }

    public static <T> T sendGetRequest(Path path, HashMap<String, String> uriParams, HashMap<String, String> queryParams, Class<T> tClass) throws IOException {
        String rawURL = AbstractClient.rawUrl(path);
        String getURL = URLUtils.urlComposite(rawURL, uriParams, queryParams);
        HttpResponse jsonNode = null;
        try {
            jsonNode = Unirest.get((String)getURL).asString();
        }
        catch (UnirestException e) {
            throw new ClientIOException(e);
        }
        return AbstractClient.parseResult(tClass, (HttpResponse<String>)jsonNode);
    }

    private static <T> T parseResult(Class<T> tClass, HttpResponse<String> jsonNode) throws IOException {
        int status = jsonNode.getStatus();
        if (status != 200) {
            String exception_msg = "response exception";
            if (status == 400) {
                exception_msg = "bad request";
            } else if (status == 403) {
                exception_msg = "request forbidden";
            }
            ClientIOException clientIOException = new ClientIOException(exception_msg + " " + (String)jsonNode.getBody());
            clientIOException.setHttpStatus(status);
            throw clientIOException;
        }
        return (T)objectMapper.readValue((String)jsonNode.getBody(), tClass);
    }

    public static <T> T sendPostRequest(Path path, HashMap<String, String> uriParams, HashMap<String, String> queryParams, Object postBody, Class<T> tClass) throws IOException {
        String rawURL = AbstractClient.rawUrl(path);
        String postURL = URLUtils.urlComposite(rawURL, uriParams, queryParams);
        HttpResponse jsonNode = null;
        String postString = objectMapper.writeValueAsString(postBody);
        try {
            jsonNode = Unirest.post((String)postURL).body(postString).asString();
        }
        catch (UnirestException e) {
            throw new ClientIOException(e);
        }
        return AbstractClient.parseResult(tClass, (HttpResponse<String>)jsonNode);
    }

    protected static HashMap<String, String> parameters(String[] keys, String[] values) {
        if (keys == null || values == null || keys.length != values.length) {
            throw ClientArgumentException.exception("Parameters creating failed");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (int index = 0; index < keys.length; ++index) {
            params.put(keys[index], values[index]);
        }
        return params;
    }

    public static ContractCallResult callContract(ContractCall call, Address contractAddress, Revision revision) throws IOException {
        Revision currentRevision = revision;
        if (currentRevision == null) {
            currentRevision = Revision.BEST;
        }
        HashMap<String, String> uriParams = AbstractClient.parameters(new String[]{"address"}, new String[]{contractAddress.toHexString(Prefix.ZeroLowerX)});
        HashMap<String, String> queryParams = AbstractClient.parameters(new String[]{"revision"}, new String[]{currentRevision.toString()});
        return AbstractClient.sendPostRequest(Path.PostContractCallPath, uriParams, queryParams, call, ContractCallResult.class);
    }

    static {
        AbstractClient.setTimeout(5000);
        objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static enum Path {
        GetAccountPath("/accounts/{address}"),
        PostContractCallPath("/accounts/{address}"),
        PostDeployContractPath("/accounts"),
        GetAccountCodePath("/accounts/{address}/code"),
        GetStorageValuePath("/accounts/{address}/storage/{key}"),
        GetTransactionPath("/transactions/{id}"),
        GetTransactionReceipt("/transactions/{id}/receipt"),
        PostTransaction("/transactions"),
        GetBlockPath("/blocks/{revision}"),
        PostFilterEventsLogPath("/events"),
        PostFilterTransferLogPath("/transfers"),
        GetNodeInfoPath("/node/network/peers");

        private final String value;

        private Path(String value) {
            this.value = value;
        }

        public String getPath() {
            return this.value;
        }
    }
}

