/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.clients;

import java.io.IOException;
import java.util.HashMap;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.clients.BlockchainClient;
import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.core.model.blockchain.Receipt;
import network.arkane.provider.core.model.blockchain.Transaction;
import network.arkane.provider.core.model.blockchain.TransferRequest;
import network.arkane.provider.core.model.blockchain.TransferResult;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.BlockRef;
import network.arkane.provider.core.model.clients.RawTransaction;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.ToClause;
import network.arkane.provider.core.model.clients.ToData;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.core.model.exception.ClientIOException;
import network.arkane.provider.utils.BlockchainUtils;
import network.arkane.provider.utils.CryptoUtils;
import network.arkane.provider.utils.RawTransactionFactory;
import network.arkane.provider.utils.StringUtils;
import network.arkane.provider.utils.crypto.ECDSASign;
import network.arkane.provider.utils.crypto.ECKeyPair;

public class TransactionClient
extends AbstractClient {
    public static final int ContractGasLimit = 21000;

    public static Transaction getTransaction(String txId, boolean isRaw, Revision revision) throws IOException {
        if (!BlockchainUtils.isId(txId)) {
            throw ClientArgumentException.exception("Tx id is invalid");
        }
        Revision currRevision = revision;
        if (currRevision == null) {
            currRevision = Revision.BEST;
        }
        HashMap<String, String> uriParams = TransactionClient.parameters(new String[]{"id"}, new String[]{txId});
        HashMap<String, String> queryParams = TransactionClient.parameters(new String[]{"revision", "raw"}, new String[]{currRevision.toString(), Boolean.toString(isRaw)});
        return TransactionClient.sendGetRequest(AbstractClient.Path.GetTransactionPath, uriParams, queryParams, Transaction.class);
    }

    public static Receipt getTransactionReceipt(String txId, Revision revision) throws IOException {
        if (!BlockchainUtils.isId(txId)) {
            throw ClientArgumentException.exception("Tx id is invalid");
        }
        Revision currRevision = revision;
        if (currRevision == null) {
            currRevision = Revision.BEST;
        }
        HashMap<String, String> uriParams = TransactionClient.parameters(new String[]{"id"}, new String[]{txId});
        HashMap<String, String> queryParams = TransactionClient.parameters(new String[]{"revision"}, new String[]{currRevision.toString()});
        return TransactionClient.sendGetRequest(AbstractClient.Path.GetTransactionReceipt, uriParams, queryParams, Receipt.class);
    }

    public static TransferResult transfer(RawTransaction transaction) throws IOException {
        byte[] rawBytes;
        if (transaction == null || transaction.getSignature() == null) {
            ClientArgumentException.exception("Raw transaction is invalid");
        }
        if ((rawBytes = transaction.encode()) == null) {
            throw ClientArgumentException.exception("Raw transaction is encode error");
        }
        String hexRaw = BytesUtils.toHexString((byte[])rawBytes, (Prefix)Prefix.ZeroLowerX);
        TransferRequest request = new TransferRequest();
        request.setRaw(hexRaw);
        return TransactionClient.sendPostRequest(AbstractClient.Path.PostTransaction, null, null, request, TransferResult.class);
    }

    public static TransferResult transfer(String rawTransactionHexString) throws IOException {
        if (!StringUtils.isHex(rawTransactionHexString)) {
            throw ClientArgumentException.exception("Raw transaction is encode error");
        }
        TransferRequest request = new TransferRequest();
        request.setRaw(rawTransactionHexString);
        return TransactionClient.sendPostRequest(AbstractClient.Path.PostTransaction, null, null, request, TransferResult.class);
    }

    public static TransferResult transfer(byte[] rawTransactionBytes) throws IOException {
        if (rawTransactionBytes == null) {
            throw ClientArgumentException.exception("rawTransaction byte array is null.");
        }
        String hexString = BytesUtils.toHexString((byte[])rawTransactionBytes, (Prefix)Prefix.ZeroLowerX);
        return TransactionClient.transfer(hexString);
    }

    public static RawTransaction sign(RawTransaction rawTransaction, ECKeyPair keyPair) {
        if (rawTransaction == null) {
            throw ClientArgumentException.exception("raw transaction object is invalid");
        }
        ECDSASign.SignatureData signature = ECDSASign.signMessage(rawTransaction.encode(), keyPair, true);
        byte[] signBytes = signature.toByteArray();
        rawTransaction.setSignature(signBytes);
        return rawTransaction;
    }

    public static TransferResult signThenTransfer(RawTransaction rawTransaction, ECKeyPair keyPair) throws IOException {
        RawTransaction signedRawTxn = TransactionClient.sign(rawTransaction, keyPair);
        return TransactionClient.transfer(signedRawTxn);
    }

    public static ToClause buildVETToClause(Address toAddress, Amount amount, ToData data) {
        if (toAddress == null) {
            throw ClientArgumentException.exception("toAddress is null");
        }
        if (amount == null) {
            throw ClientArgumentException.exception("amount is null");
        }
        if (data == null) {
            throw ClientArgumentException.exception("data is null");
        }
        return new ToClause(toAddress, amount, data);
    }

    public static ToClause buildDeployClause(String contractHex) {
        if (!StringUtils.isHex(contractHex)) {
            return null;
        }
        ToData toData = new ToData();
        toData.setData(contractHex);
        return new ToClause(Address.NULL_ADDRESS, Amount.ZERO, toData);
    }

    public static TransferResult deployContract(String contractHex, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        ToClause toClause = TransactionClient.buildDeployClause(contractHex);
        if (toClause == null) {
            throw ClientArgumentException.exception("The contract hex string is null");
        }
        ToClause[] toClauses = new ToClause[]{toClause};
        return TransactionClient.invokeContractMethod(toClauses, gas, gasCoef, expiration, keyPair);
    }

    protected static TransferResult invokeContractMethod(ToClause[] toClauses, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (keyPair == null) {
            throw ClientArgumentException.exception("ECKeyPair is null.");
        }
        if (gas < 21000) {
            throw ClientArgumentException.exception("gas is too small.");
        }
        if (gasCoef < 0) {
            throw ClientArgumentException.exception("gas coef is too small.");
        }
        if (expiration <= 0) {
            throw ClientArgumentException.exception("expiration is invalid.");
        }
        if (toClauses == null) {
            throw ClientArgumentException.exception("To clause is null");
        }
        byte chainTag = BlockchainClient.getChainTag();
        BlockRef bestRef = BlockchainClient.getBlockRef(null);
        if (bestRef == null || chainTag == 0) {
            throw new ClientIOException("Get chainTag: " + chainTag + " BlockRef: " + bestRef);
        }
        RawTransaction rawTransaction = RawTransactionFactory.getInstance().createRawTransaction(chainTag, bestRef.toByteArray(), expiration, gas, gasCoef, CryptoUtils.generateTxNonce(), toClauses);
        return TransactionClient.signThenTransfer(rawTransaction, keyPair);
    }
}

