/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.generation;

import network.arkane.provider.JSONUtil;
import network.arkane.provider.wallet.generation.GeneratedWallet;
import org.apache.commons.codec.binary.Base64;
import org.web3j.crypto.WalletFile;

public class GeneratedVechainWallet
implements GeneratedWallet {
    private String address;
    private WalletFile walletFile;

    public String getAddress() {
        return this.address;
    }

    public String secretAsBase64() {
        return Base64.encodeBase64String((byte[])JSONUtil.toJson((Object)this.walletFile).getBytes());
    }

    GeneratedVechainWallet(String address, WalletFile walletFile) {
        this.address = address;
        this.walletFile = walletFile;
    }

    public static GeneratedVechainWalletBuilder builder() {
        return new GeneratedVechainWalletBuilder();
    }

    public WalletFile getWalletFile() {
        return this.walletFile;
    }

    public static class GeneratedVechainWalletBuilder {
        private String address;
        private WalletFile walletFile;

        GeneratedVechainWalletBuilder() {
        }

        public GeneratedVechainWalletBuilder address(String address) {
            this.address = address;
            return this;
        }

        public GeneratedVechainWalletBuilder walletFile(WalletFile walletFile) {
            this.walletFile = walletFile;
            return this;
        }

        public GeneratedVechainWallet build() {
            return new GeneratedVechainWallet(this.address, this.walletFile);
        }

        public String toString() {
            return "GeneratedVechainWallet.GeneratedVechainWalletBuilder(address=" + this.address + ", walletFile=" + this.walletFile + ")";
        }
    }
}

