/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.utils.CryptoUtils;

public class StorageKey {
    private byte[] data = new byte[64];

    public static StorageKey create(int index, byte[] value) {
        if (index < 0) {
            throw new IllegalArgumentException("index is invalid.");
        }
        if (value == null || value.length > 32) {
            throw new IllegalArgumentException("value is invalid.");
        }
        byte[] indexBytes = new byte[32];
        byte[] valueBytes = value;
        byte[] originIndexBytes = BytesUtils.longToBytes((long)index);
        System.arraycopy(originIndexBytes, 0, indexBytes, indexBytes.length - originIndexBytes.length, originIndexBytes.length);
        if (value.length < 32) {
            valueBytes = new byte[32];
            System.arraycopy(value, 0, valueBytes, valueBytes.length - value.length, value.length);
        }
        return new StorageKey(indexBytes, valueBytes);
    }

    private StorageKey(byte[] index, byte[] value) {
        System.arraycopy(index, 0, this.data, 0, index.length);
        System.arraycopy(value, 0, this.data, index.length, value.length);
    }

    public String hexKey() {
        byte[] key = CryptoUtils.keccak256(this.data);
        return BytesUtils.toHexString((byte[])key, (Prefix)Prefix.ZeroLowerX);
    }
}

