/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.blockchain;

import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.utils.StringUtils;

public class NodeProvider {
    private static NodeProvider INSTANCE = new NodeProvider();
    private String provider;
    private int socketTimeout = 5000;
    private int connectTimeout = 5000;

    public static NodeProvider getNodeProvider() {
        return INSTANCE;
    }

    private NodeProvider() {
    }

    public String getProvider() {
        if (StringUtils.isBlank(this.provider) || !this.provider.startsWith("http")) {
            throw new RuntimeException("The blockchain provider url must be set.");
        }
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public void setTimeout(int timeout) {
        AbstractClient.setTimeout(timeout);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }
}

