/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.ToClause;
import network.arkane.provider.core.model.clients.ToData;
import network.arkane.provider.core.model.clients.base.AbiDefinition;
import network.arkane.provider.utils.ContractParamEncoder;
import org.apache.commons.lang3.StringUtils;

public class AbstractContract {
    private List<AbiDefinition> abiDefinitionList;

    public AbstractContract(String abiJsonString) {
        this.abiDefinitionList = AbstractContract.parseAbiList(abiJsonString);
    }

    public static ContractCall buildCall(AbiDefinition definition, Object ... hexParameters) {
        return AbstractContract.buildCall(null, definition, hexParameters);
    }

    public static ContractCall buildCall(String caller, AbiDefinition definition, Object ... hexParameters) {
        if (definition == null) {
            throw new IllegalArgumentException("definition is null");
        }
        String data = AbstractContract.buildData(definition, hexParameters);
        ContractCall contractCall = new ContractCall();
        contractCall.setData(data);
        contractCall.setValue("0x0");
        contractCall.setCaller(caller);
        return contractCall;
    }

    public AbiDefinition findAbiDefinition(String name) {
        return this.findAbiDefinition(name, "function", null);
    }

    public AbiDefinition findAbiDefinition(String name, String type, List<String> inputTypes) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException("name or type is blank.");
        }
        for (AbiDefinition abiDefinition : this.abiDefinitionList) {
            if (!abiDefinition.getName().equals(name) || !abiDefinition.getType().equals(type)) continue;
            if (inputTypes != null) {
                if (!this.checkInputsType(inputTypes, abiDefinition)) continue;
                return abiDefinition;
            }
            return abiDefinition;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " doesn't has abi define of name:" + name);
    }

    private boolean checkInputsType(List<String> inputTypes, AbiDefinition abiDefinition) {
        if (inputTypes == null) {
            return false;
        }
        if (abiDefinition == null) {
            return false;
        }
        if (inputTypes.size() != abiDefinition.getInputs().size()) {
            return false;
        }
        for (int index = 0; index < inputTypes.size(); ++index) {
            if (inputTypes.get(index).equals(abiDefinition.getInputs().get(index).getType())) continue;
            return false;
        }
        return true;
    }

    public static ToClause buildToClause(Address toAddress, AbiDefinition abiDefinition, Object ... hexArguments) {
        ToData toData = new ToData();
        String data = AbstractContract.buildData(abiDefinition, hexArguments);
        toData.setData(data);
        return new ToClause(toAddress, Amount.ZERO, toData);
    }

    public static String buildData(AbiDefinition abiDefinition, Object ... params) {
        if (abiDefinition == null) {
            return null;
        }
        List<AbiDefinition.NamedType> inputs = abiDefinition.getInputs();
        if (inputs == null || params == null || inputs.size() != params.length) {
            throw new IllegalArgumentException("Parameters length is not valid");
        }
        StringBuilder dataBuffer = new StringBuilder();
        dataBuffer.append(abiDefinition.getHexMethodCodeNoPefix());
        int dynamicDataOffset = ContractParamEncoder.getLength(inputs, params) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (int index = 0; index < params.length; ++index) {
            Object param = params[index];
            String abiType = inputs.get(index).getType();
            String code = ContractParamEncoder.encode(abiType, param);
            boolean isDynamic = ContractParamEncoder.isDynamic(index, param, abiType);
            if (isDynamic) {
                String encodedDataOffset = ContractParamEncoder.encodeNumeric(BigInteger.valueOf(dynamicDataOffset), true);
                dataBuffer.append(encodedDataOffset);
                dynamicData.append(code);
                dynamicDataOffset += code.length() >> 1;
                continue;
            }
            dataBuffer.append(code);
        }
        dataBuffer.append((CharSequence)dynamicData);
        return "0x" + dataBuffer.toString();
    }

    private static List<AbiDefinition> parseAbiList(String abisString) {
        ObjectMapper objectMapper = new ObjectMapper();
        AbiDefinition[] list = null;
        try {
            list = (AbiDefinition[])objectMapper.readValue(abisString, AbiDefinition[].class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (list == null) {
            return null;
        }
        return Arrays.asList(list);
    }
}

