/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.decryption;

import network.arkane.provider.secret.generation.VechainSecretKey;
import network.arkane.provider.wallet.decryption.WalletDecryptor;
import network.arkane.provider.wallet.generation.GeneratedVechainWallet;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class VechainWalletDecryptor
implements WalletDecryptor<GeneratedVechainWallet, VechainSecretKey> {
    public VechainSecretKey generateKey(GeneratedVechainWallet generatedWallet, String password) {
        try {
            ECKeyPair keyPair = Wallet.decrypt((String)password, (WalletFile)generatedWallet.getWalletFile());
            return VechainSecretKey.builder().keyPair(keyPair).build();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to fetch secret");
        }
    }
}

