/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.core.model.clients.base.AbiDefinition;
import network.arkane.provider.utils.StringUtils;

public class ContractParamEncoder {
    public static final int MAX_BIT_LENGTH = 256;
    public static final int MAX_BYTE_LENGTH = 32;
    public static final int DEFAULT_BIT_LENGTH = 128;

    public static boolean isDynamic(int index, Object param, String abiType) {
        boolean isDynamic = false;
        switch (abiType) {
            case "string": {
                if (!(param instanceof String)) {
                    throw new IllegalArgumentException("Parameter format is not match! index:" + index + " expect: " + abiType + ",but get " + param.getClass().getSimpleName());
                }
                isDynamic = true;
                break;
            }
            case "bytes": {
                if (!param.getClass().isArray()) {
                    throw new IllegalArgumentException("Parameter format is not match! index:" + index + " expect: " + abiType + ",but get " + param.getClass().getSimpleName());
                }
                try {
                    byte[] byArray = (byte[])param;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Parameter format is not match! index:" + index + " expect: " + abiType + ",but get " + param.getClass().getSimpleName());
                }
                isDynamic = true;
                break;
            }
            default: {
                if (!abiType.contains("[]")) break;
                if (!param.getClass().isArray()) {
                    throw new IllegalArgumentException("Parameter format is not match! index:" + index + " expect: " + abiType + ",but get " + param.getClass().getSimpleName());
                }
                isDynamic = true;
            }
        }
        return isDynamic;
    }

    public static int getLength(List<AbiDefinition.NamedType> inputs, Object ... params) {
        int count = 0;
        Pattern pattern = Pattern.compile("\\w+\\[\\d+\\]*");
        for (int i = 0; i < params.length; ++i) {
            Matcher matcher = pattern.matcher(inputs.get(i).getType());
            if (matcher.matches()) {
                if (params[i].getClass().isArray()) {
                    count += Array.getLength(params[i]);
                    continue;
                }
                if (params[i] instanceof List) {
                    count += ((List)params[i]).size();
                    continue;
                }
                throw new IllegalArgumentException(inputs.get(i).getType() + " " + params[i].getClass().getSimpleName());
            }
            ++count;
        }
        return count;
    }

    public static String encode(String abiType, Object param) {
        try {
            if (abiType.contains("[]")) {
                ArrayList<Object> list = new ArrayList<Object>();
                String type = abiType.substring(0, abiType.indexOf("["));
                for (int i = 0; i < Array.getLength(param); ++i) {
                    list.add(Array.get(param, i));
                }
                return ContractParamEncoder.encodeDynamicArray(type, list);
            }
            if (abiType.contains("[")) {
                ArrayList<Object> list = new ArrayList<Object>();
                String type = abiType.substring(0, abiType.indexOf("["));
                if (param instanceof List) {
                    list.addAll((List)param);
                } else {
                    for (int i = 0; i < Array.getLength(param); ++i) {
                        list.add(Array.get(param, i));
                    }
                }
                return ContractParamEncoder.encodeArrayValues(type, list);
            }
            if (abiType.startsWith("int")) {
                return ContractParamEncoder.encodeNumeric((BigInteger)param, false);
            }
            if (abiType.startsWith("uint")) {
                return ContractParamEncoder.encodeNumeric((BigInteger)param, true);
            }
            if (abiType.equals("fixed")) {
                return ContractParamEncoder.encodeNumeric((BigInteger)param, false);
            }
            if (abiType.equals("ufixed")) {
                return ContractParamEncoder.encodeNumeric((BigInteger)param, true);
            }
            if (abiType.equals("address")) {
                return ContractParamEncoder.encodeAddress((String)param);
            }
            if (abiType.equals("bool")) {
                return ContractParamEncoder.encodeBool((Boolean)param);
            }
            if (abiType.equals("bytes")) {
                return ContractParamEncoder.encodeDynamicBytes((byte[])param);
            }
            if (abiType.startsWith("bytes")) {
                return ContractParamEncoder.encodeBytes((byte[])param);
            }
            if (abiType.equals("string")) {
                return ContractParamEncoder.encodeString((String)param);
            }
            throw new UnsupportedOperationException("Type cannot be encoded: " + abiType);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Type cannot be encoded: " + abiType + " paramClass:" + param.getClass().getSimpleName(), e);
        }
    }

    public static String encodeAddress(String address) {
        if (!StringUtils.isHex(address)) {
            throw new IllegalArgumentException("Parameter format is not hex string");
        }
        byte[] paramBytes = BytesUtils.toByteArray((String)address);
        if (paramBytes == null || paramBytes.length > 32) {
            throw new IllegalArgumentException("Parameter format is hex string size too large, or null");
        }
        if (paramBytes.length < 32) {
            byte[] fillingZero = new byte[32];
            System.arraycopy(paramBytes, 0, fillingZero, 32 - paramBytes.length, paramBytes.length);
            return BytesUtils.toHexString((byte[])fillingZero, null);
        }
        return BytesUtils.cleanHexPrefix((String)address);
    }

    public static String encodeNumeric(BigInteger numericType, boolean isSigned) {
        byte[] rawValue = ContractParamEncoder.toByteArray(numericType, isSigned);
        byte paddingValue = ContractParamEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return BytesUtils.toHexString((byte[])paddedRawValue, null);
    }

    private static byte getPaddingValue(BigInteger numericType) {
        if (numericType.signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(BigInteger value, boolean isSigned) {
        if (isSigned && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    public static String encodeBool(boolean value) {
        byte[] rawValue = new byte[32];
        if (value) {
            rawValue[rawValue.length - 1] = 1;
        }
        return BytesUtils.toHexString((byte[])rawValue, null);
    }

    public static String encodeBytes(byte[] value) {
        byte[] dest;
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return BytesUtils.toHexString((byte[])dest, null);
    }

    public static String encodeDynamicBytes(byte[] dynamicBytes) {
        int size = dynamicBytes.length;
        String encodedLength = ContractParamEncoder.encode("uint", BigInteger.valueOf(size));
        String encodedValue = ContractParamEncoder.encodeBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    public static String encodeString(String string) {
        byte[] utfEncoded = string.getBytes(StandardCharsets.UTF_8);
        return ContractParamEncoder.encodeDynamicBytes(utfEncoded);
    }

    public static String encodeArrayValues(String type, List<Object> value) {
        StringBuilder result = new StringBuilder();
        for (Object o : value) {
            result.append(ContractParamEncoder.encode(type, o));
        }
        return result.toString();
    }

    public static <T> String encodeDynamicArray(String type, List<Object> value) {
        int size = value.size();
        String encodedLength = ContractParamEncoder.encode("uint", BigInteger.valueOf(size));
        String encodedValues = ContractParamEncoder.encodeArrayValues(type, value);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValues);
        return result.toString();
    }

    public static BigInteger convertFixed(BigInteger m, BigInteger n) {
        return ContractParamEncoder.convertFixed(128, 128, m, n);
    }

    public static BigInteger convertFixed(int mBitSize, int nBitSize, BigInteger m, BigInteger n) {
        BigInteger mPadded = m.shiftLeft(nBitSize);
        int nBitLength = n.bitLength();
        int shift = nBitLength + 3 & 0xFFFFFFFC;
        return mPadded.or(n.shiftLeft(nBitSize - shift));
    }
}

