/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils.crypto;

import java.math.BigInteger;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.utils.crypto.ECKeyPair;

public class ECDSASignature {
    public final BigInteger r;
    public final BigInteger s;

    public ECDSASignature(byte[] rBytes, byte[] sBytes) {
        this.r = BytesUtils.bytesToBigInt((byte[])rBytes);
        this.s = BytesUtils.bytesToBigInt((byte[])sBytes);
    }

    public ECDSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    boolean isCanonical() {
        return this.s.compareTo(ECKeyPair.HALF_CURVE_ORDER) <= 0;
    }

    public ECDSASignature toCanonicalised() {
        if (!this.isCanonical()) {
            return new ECDSASignature(this.r, ECKeyPair.CURVE.getN().subtract(this.s));
        }
        return this;
    }
}

