/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import java.util.Objects;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.utils.BlockchainUtils;
import network.arkane.provider.utils.StringUtils;

public class Address {
    public static Address NULL_ADDRESS = new NULLAddress();
    public static Address VTHO_Address = Address.fromHexString("0x0000000000000000000000000000456e65726779");
    private static final int ADDRESS_SIZE = 20;
    private String sanitizeHexAddress;

    public static Address fromBytes(byte[] addressBytes) {
        if (addressBytes != null && addressBytes.length == 20) {
            return new Address(addressBytes);
        }
        throw ClientArgumentException.exception("Address.fromBytes Argument Exception");
    }

    public static Address fromHexString(String hexAddress) {
        if (StringUtils.isBlank(hexAddress)) {
            throw ClientArgumentException.exception("Address.fromHexString hexAddress is blank string");
        }
        if (!BlockchainUtils.isAddress(hexAddress)) {
            throw ClientArgumentException.exception("Address.fromHexString hexAddress is not hex format ");
        }
        String sanitizeHexStr = StringUtils.sanitizeHex(hexAddress);
        return new Address(sanitizeHexStr);
    }

    private Address(byte[] addressBytes) {
        this.sanitizeHexAddress = BytesUtils.toHexString((byte[])addressBytes, null);
    }

    private Address(String sanitizeHexAddress) {
        this.sanitizeHexAddress = sanitizeHexAddress;
    }

    private Address() {
    }

    public byte[] toByteArray() {
        return BytesUtils.toByteArray((String)this.sanitizeHexAddress);
    }

    public String toHexString(Prefix prefix) {
        if (prefix != null) {
            return prefix.getPrefixString() + this.sanitizeHexAddress;
        }
        return this.sanitizeHexAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.sanitizeHexAddress, address.sanitizeHexAddress);
    }

    public int hashCode() {
        return Objects.hash(this.sanitizeHexAddress);
    }

    private static class NULLAddress
    extends Address {
        private NULLAddress() {
        }

        @Override
        public byte[] toByteArray() {
            return new byte[0];
        }
    }
}

