/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.token;

import java.math.BigInteger;
import java.util.Optional;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.gateway.VechainGateway;
import network.arkane.provider.token.NativeTokenDiscoveryService;
import network.arkane.provider.token.TokenInfo;
import org.springframework.stereotype.Component;

@Component
public class NativeVechainTokenDiscoveryService
implements NativeTokenDiscoveryService {
    private VechainGateway vechainGateway;

    public NativeVechainTokenDiscoveryService(VechainGateway vechainGateway) {
        this.vechainGateway = vechainGateway;
    }

    public Optional<TokenInfo> getTokenInfo(String tokenAddress) {
        String name = this.vechainGateway.getTokenName(tokenAddress);
        String symbol = this.vechainGateway.getTokenSymbol(tokenAddress);
        BigInteger decimals = this.vechainGateway.getTokenDecimals(tokenAddress);
        if (name != null && decimals != null && symbol != null) {
            return Optional.of(TokenInfo.builder().address(tokenAddress).name(name).decimals(Integer.valueOf(decimals.intValue())).symbol(symbol).type("VIP180").build());
        }
        return Optional.empty();
    }

    public SecretType type() {
        return SecretType.VECHAIN;
    }
}

