/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.clients;

import java.io.IOException;
import java.math.BigInteger;
import network.arkane.provider.Prefix;
import network.arkane.provider.clients.TransactionClient;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.blockchain.ContractCallResult;
import network.arkane.provider.core.model.blockchain.TransferResult;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.ERC20Contract;
import network.arkane.provider.core.model.clients.ERC20Token;
import network.arkane.provider.core.model.clients.ProtoTypeContract;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.ToClause;
import network.arkane.provider.core.model.clients.base.AbiDefinition;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.utils.crypto.ECKeyPair;

public class ERC20ContractClient
extends TransactionClient {
    public static Amount getERC20Balance(Address address, ERC20Token token, Revision revision) throws IOException {
        Address contractAddr = token.getContractAddress();
        Revision currRevision = revision;
        if (currRevision == null) {
            currRevision = Revision.BEST;
        }
        AbiDefinition abiDefinition = ERC20Contract.defaultERC20Contract.findAbiDefinition("balanceOf");
        ContractCall call = ERC20Contract.buildCall(abiDefinition, address.toHexString(null));
        ContractCallResult contractCallResult = ERC20ContractClient.callContract(call, contractAddr, currRevision);
        if (contractCallResult == null) {
            return null;
        }
        return contractCallResult.getBalance(token);
    }

    public static String name(Address address) throws IOException {
        Revision currRevision = Revision.BEST;
        AbiDefinition abiDefinition = ERC20Contract.defaultERC20Contract.findAbiDefinition("name");
        ContractCall call = ERC20Contract.buildCall(abiDefinition, new Object[0]);
        ContractCallResult contractCallResult = ERC20ContractClient.callContract(call, address, currRevision);
        return contractCallResult.getData();
    }

    public static String symbol(Address address) throws IOException {
        Revision currRevision = Revision.BEST;
        AbiDefinition abiDefinition = ERC20Contract.defaultERC20Contract.findAbiDefinition("symbol");
        ContractCall call = ERC20Contract.buildCall(abiDefinition, new Object[0]);
        ContractCallResult contractCallResult = ERC20ContractClient.callContract(call, address, currRevision);
        return contractCallResult.getData();
    }

    public static BigInteger decimals(Address address) throws IOException {
        Revision currRevision = Revision.BEST;
        AbiDefinition abiDefinition = ERC20Contract.defaultERC20Contract.findAbiDefinition("decimals");
        ContractCall call = ERC20Contract.buildCall(abiDefinition, new Object[0]);
        ContractCallResult contractCallResult = ERC20ContractClient.callContract(call, address, currRevision);
        return new BigInteger(contractCallResult.getData());
    }

    public static TransferResult transferERC20Token(Address[] receivers, Amount[] amounts, int gas, byte gasCoef, int expiration, ECKeyPair keyPair) throws IOException {
        if (receivers == null) {
            throw ClientArgumentException.exception("receivers is null");
        }
        if (amounts == null) {
            throw ClientArgumentException.exception("amounts is null");
        }
        if (receivers.length != amounts.length) {
            throw ClientArgumentException.exception("receivers length equal to amounts length.");
        }
        AbiDefinition abi = ERC20Contract.defaultERC20Contract.findAbiDefinition("transfer");
        if (abi == null) {
            throw new IllegalArgumentException("Can not find abi master method");
        }
        ToClause[] clauses = new ToClause[receivers.length];
        for (int index = 0; index < receivers.length; ++index) {
            if (!(amounts[index].getAbstractToken() instanceof ERC20Token)) {
                throw ClientArgumentException.exception("Token is not ERC20");
            }
            ERC20Token token = (ERC20Token)amounts[index].getAbstractToken();
            clauses[index] = ProtoTypeContract.buildToClause(token.getContractAddress(), abi, receivers[index].toHexString(Prefix.ZeroLowerX), amounts[index].toBigInteger());
        }
        return ERC20ContractClient.invokeContractMethod(clauses, gas, gasCoef, expiration, keyPair);
    }
}

