/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.nonfungible;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import network.arkane.provider.business.token.BusinessTokenGateway;
import network.arkane.provider.business.token.model.TokenContract;
import network.arkane.provider.business.token.model.TokenDto;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.nonfungible.NonFungibleGateway;
import network.arkane.provider.nonfungible.domain.NonFungibleAsset;
import network.arkane.provider.nonfungible.domain.NonFungibleContract;
import org.springframework.stereotype.Service;

@Service
public class VechainNonFungibleGateway
implements NonFungibleGateway {
    public static final String CONTRACT_TYPE = "ERC_1155";
    final BusinessTokenGateway businessTokenGateway;

    public VechainNonFungibleGateway(BusinessTokenGateway businessTokenGateway) {
        this.businessTokenGateway = businessTokenGateway;
    }

    public SecretType getSecretType() {
        return SecretType.VECHAIN;
    }

    public List<NonFungibleAsset> listNonFungibles(String walletId, String ... contractAddresses) {
        return this.businessTokenGateway.getTokensForAddress(walletId).stream().filter(x -> x.getTokenType().isNf()).map(x -> NonFungibleAsset.builder().tokenId(x.getContractTokenId().toString()).contract(NonFungibleContract.builder().name(x.getTokenType().getTokenContract().getName()).description(x.getTokenType().getTokenContract().getDescription()).address(x.getTokenType().getTokenContract().getAddress()).symbol(null).url(null).imageUrl(null).type(CONTRACT_TYPE).build()).description(x.getTokenType().getDescription()).name(x.getTokenType().getName()).imageUrl(x.getImageUrl()).imagePreviewUrl(x.getImagePreviewUrl()).imageThumbnailUrl(x.getImageThumbnailUrl()).build()).collect(Collectors.toList());
    }

    public NonFungibleAsset getNonFungible(String contractAddress, String tokenId) {
        TokenDto token = this.businessTokenGateway.getToken(contractAddress, new BigInteger(tokenId));
        return NonFungibleAsset.builder().tokenId(tokenId).imagePreviewUrl(token.getImagePreviewUrl()).contract(this.getNonFungibleContract(contractAddress)).backgroundColor(token.getBackgroundColor()).imageThumbnailUrl(token.getImageThumbnailUrl()).imageUrl(token.getImageUrl()).url(token.getUrl()).name(token.getTokenType().getName()).description(token.getTokenType().getDescription()).build();
    }

    public NonFungibleContract getNonFungibleContract(String contractAddress) {
        TokenContract contract = this.businessTokenGateway.getContract(contractAddress);
        return NonFungibleContract.builder().address(contract.getAddress()).description(contract.getDescription()).name(contract.getName()).type(CONTRACT_TYPE).build();
    }
}

