/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.utils.StringUtils;

public class BlockRef {
    private byte[] blockRef = new byte[8];

    private BlockRef(byte[] blockIdBytes) {
        System.arraycopy(blockIdBytes, 0, this.blockRef, 0, 8);
    }

    public static BlockRef create(String hexBlockId) {
        if (!StringUtils.isHex(hexBlockId)) {
            throw new IllegalArgumentException("hex block id is invalid");
        }
        byte[] blockIdBytes = BytesUtils.toByteArray((String)hexBlockId);
        return new BlockRef(blockIdBytes);
    }

    public String toString() {
        return BytesUtils.toHexString((byte[])this.blockRef, (Prefix)Prefix.ZeroLowerX);
    }

    public byte[] toByteArray() {
        return this.blockRef;
    }
}

