/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.exporting;

import network.arkane.provider.JSONUtil;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.secret.generation.VechainSecretKey;
import network.arkane.provider.wallet.decryption.VechainWalletDecryptor;
import network.arkane.provider.wallet.exporting.KeyExporter;
import network.arkane.provider.wallet.generation.GeneratedVechainWallet;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class VechainKeystoreExporter
implements KeyExporter<VechainSecretKey> {
    private VechainWalletDecryptor vechainWalletDecryptor;

    public VechainKeystoreExporter(VechainWalletDecryptor vechainWalletDecryptor) {
        this.vechainWalletDecryptor = vechainWalletDecryptor;
    }

    public String export(VechainSecretKey key, String password) {
        try {
            return JSONUtil.toJson((Object)Wallet.createStandard((String)password, (ECKeyPair)key.getKeyPair()));
        }
        catch (Exception ex) {
            throw ArkaneException.arkaneException().errorCode("export.vechain").message("An error occurred while trying to export the key").build();
        }
    }

    public VechainSecretKey reconstructKey(String secret, String password) {
        return this.vechainWalletDecryptor.generateKey(GeneratedVechainWallet.builder().walletFile((WalletFile)JSONUtil.fromJson((String)secret, WalletFile.class)).build(), password);
    }

    public SecretType type() {
        return SecretType.VECHAIN;
    }
}

