/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils;

import com.rfksystems.blake2b.Blake2b;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.jcajce.provider.digest.Keccak;

public class CryptoUtils {
    public static byte[] blake2b(byte[] message) {
        Blake2b blake2b = new Blake2b(256);
        blake2b.update(message, 0, message.length);
        byte[] digest = new byte[32];
        int size = blake2b.digest(digest, 0);
        if (size > 0) {
            return digest;
        }
        return null;
    }

    public static byte[] generateTxNonce() {
        if (CryptoUtils.isAndroidRuntime()) {
            throw new RuntimeException("The random nonce is not supporting the Android OS.");
        }
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[8];
        random.nextBytes(bytes);
        return bytes;
    }

    static boolean isAndroidRuntime() {
        String runtime = System.getProperty("java.runtime.name");
        boolean isAndroid = runtime != null && runtime.equals("Android Runtime");
        return isAndroid;
    }

    public static byte[] keccak256(byte[] message) {
        return CryptoUtils.keccak256(message, 0, message.length);
    }

    public static byte[] keccak256(byte[] message, int offset, int size) {
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(message, offset, size);
        return kecc.digest();
    }

    public static byte[] randomBytes(int byteSize) {
        if (CryptoUtils.isAndroidRuntime()) {
            throw new RuntimeException("The random nonce is not supporting the Android OS.");
        }
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[byteSize];
        random.nextBytes(randomBytes);
        return randomBytes;
    }

    public static byte[] sha256(byte[] bytes) {
        return CryptoUtils.sha256(bytes, 0, bytes.length);
    }

    public static byte[] sha256(byte[] bytes, int offset, int size) {
        SHA256Digest sha256Digest = new SHA256Digest();
        sha256Digest.update(bytes, offset, size);
        byte[] sha256 = new byte[32];
        sha256Digest.doFinal(sha256, 0);
        return sha256;
    }

    public static byte[] doubleSha256(byte[] bytes) {
        return CryptoUtils.doubleSha256(bytes, 0, bytes.length);
    }

    public static byte[] doubleSha256(byte[] bytes, int offset, int size) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(bytes, offset, size);
            return sha256.digest(sha256.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

