/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils.crypto;

import java.math.BigInteger;
import java.security.SecureRandom;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.utils.CryptoUtils;
import network.arkane.provider.utils.crypto.ECDSASign;
import network.arkane.provider.utils.crypto.ECDSASignature;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;

public class ECKeyPair {
    public static final int PRIVATE_KEY_SIZE = 32;
    private static final int PUBLIC_KEY_SIZE = 64;
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    public static final BigInteger HALF_CURVE_ORDER = CURVE_PARAMS.getN().shiftRight(1);
    public static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final ECDomainParameters domain = new ECDomainParameters(CURVE.getCurve(), CURVE.getG(), CURVE.getN(), CURVE.getH());
    private final BigInteger privateKey;
    private final BigInteger publicKey;

    public ECKeyPair(BigInteger privateKey, BigInteger publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getRawPrivateKey() {
        return BytesUtils.toBytesPadded((BigInteger)this.privateKey, (int)32);
    }

    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    public byte[] getRawPublicKey() {
        return BytesUtils.toBytesPadded((BigInteger)this.publicKey, (int)64);
    }

    public byte[] getRawAddress() {
        byte[] hash = CryptoUtils.keccak256(this.getRawPublicKey());
        byte[] address = new byte[20];
        System.arraycopy(hash, 12, address, 0, address.length);
        return address;
    }

    public String getHexAddress() {
        byte[] addressBytes = this.getRawAddress();
        return BytesUtils.toHexString((byte[])addressBytes, (Prefix)Prefix.ZeroLowerX);
    }

    public ECDSASignature sign(byte[] message) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.privateKey, CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(message);
        return new ECDSASignature(components[0], components[1]).toCanonicalised();
    }

    public static ECKeyPair create(BigInteger privateKey) {
        return new ECKeyPair(privateKey, ECDSASign.publicKeyFromPrivate(privateKey));
    }

    public static ECKeyPair create(String privateKeyHex) {
        byte[] privKey = BytesUtils.toByteArray((String)privateKeyHex);
        return ECKeyPair.create(privKey);
    }

    public static ECKeyPair create(byte[] privateKey) {
        if (privateKey.length == 32) {
            return ECKeyPair.create(BytesUtils.bytesToBigInt((byte[])privateKey));
        }
        throw new IllegalArgumentException("Invalid privatekey size");
    }

    public static ECKeyPair create() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(domain, secureRandom);
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        ECKeyPair k = ECKeyPair.create(privParams.getD());
        return k;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair ecKeyPair = (ECKeyPair)o;
        if (this.privateKey != null ? !this.privateKey.equals(ecKeyPair.privateKey) : ecKeyPair.privateKey != null) {
            return false;
        }
        return this.publicKey != null ? this.publicKey.equals(ecKeyPair.publicKey) : ecKeyPair.publicKey == null;
    }

    public int hashCode() {
        int result = this.privateKey != null ? this.privateKey.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }
}

