/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils;

import network.arkane.provider.BytesUtils;
import network.arkane.provider.core.model.blockchain.RawClause;
import network.arkane.provider.core.model.clients.RawTransaction;
import network.arkane.provider.core.model.clients.ToClause;
import network.arkane.provider.utils.RawTransactionBuilder;

public class RawTransactionFactory {
    private static RawTransactionFactory INSTANCE = new RawTransactionFactory();

    public RawTransaction createRawTransaction(byte chainTag, byte[] blockRef, int expiration, int gasInt, byte gasPriceCoef, byte[] nonce, ToClause ... toClauses) throws IllegalArgumentException {
        if (chainTag == 0 || blockRef == null || expiration <= 0 || gasInt < 21000 || gasPriceCoef < 0 || toClauses == null) {
            throw new IllegalArgumentException("The arguments of create raw transaction is illegal.");
        }
        RawTransactionBuilder builder = new RawTransactionBuilder();
        builder.update(chainTag, "chainTag");
        byte[] expirationBytes = BytesUtils.longToBytes((long)expiration);
        builder.update(expirationBytes, "expiration");
        byte[] currentBlockRef = BytesUtils.trimLeadingZeroes((byte[])blockRef);
        builder.update(currentBlockRef, "blockRef");
        byte[] trimedNonce = BytesUtils.trimLeadingZeroes((byte[])nonce);
        builder.update(trimedNonce, "nonce");
        byte[] gas = BytesUtils.longToBytes((long)gasInt);
        builder.update(gas, "gas");
        builder.update(gasPriceCoef, "gasPriceCoef");
        int size = toClauses.length;
        RawClause[] rawClauses = new RawClause[size];
        int index = 0;
        for (ToClause clause : toClauses) {
            rawClauses[index] = new RawClause();
            rawClauses[index].setTo(clause.getTo().toByteArray());
            rawClauses[index].setValue(clause.getValue().toByteArray());
            rawClauses[index].setData(clause.getData().toByteArray());
            ++index;
        }
        builder.update(rawClauses);
        RawTransaction rawTxn = builder.build();
        return rawTxn;
    }

    public static RawTransactionFactory getInstance() {
        return INSTANCE;
    }
}

