/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import network.arkane.provider.BytesUtils;
import network.arkane.provider.utils.StringUtils;

public class ToData {
    public static ToData ZERO = new Zero();
    private String hexString;

    public void setData(String hexString) {
        if (!StringUtils.isHex(hexString)) {
            throw new IllegalArgumentException("hex string is not valid");
        }
        String noPrefixHex = StringUtils.sanitizeHex(hexString);
        if (noPrefixHex.length() <= 0) {
            throw new IllegalArgumentException("hex string is not valid");
        }
        this.hexString = hexString;
    }

    public byte[] toByteArray() {
        return BytesUtils.toByteArray((String)this.hexString);
    }

    private static class Zero
    extends ToData {
        private Zero() {
        }

        @Override
        public byte[] toByteArray() {
            return new byte[0];
        }

        @Override
        public void setData(String hexString) {
            throw new RuntimeException("Not allowed to call");
        }
    }
}

