package network.arkane.provider.clients;

import network.arkane.provider.Prefix;
import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.core.model.blockchain.EventFilter;
import network.arkane.provider.core.model.blockchain.FilteredEvent;
import network.arkane.provider.core.model.blockchain.FilteredTransfer;
import network.arkane.provider.core.model.blockchain.Order;
import network.arkane.provider.core.model.blockchain.TransferFilter;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.core.model.exception.ClientIOException;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * Get log generated by contract with event filter or transfer logs.
 */
public class LogsClient extends AbstractClient {

    /**
     * Get events log from a address.
     *
     * @param filter  required {@link EventFilter} a filter for the events log.
     * @param order   optional ,{@link Order} a time order for the events list.
     * @param address optional, {@link Address} a address which has events log.
     * @return array of {@link FilteredEvent}, could be null. throws
     * ClientIOException network error or request invalid.
     */
    public static ArrayList<?> filterEvents(EventFilter filter, Order order, Address address) throws IOException {
        if (filter == null) {
            throw ClientArgumentException.exception("filter is null");
        }
        HashMap<String, String> queryParams = new HashMap<>();
        if (order != null) {
            queryParams.put("order", order.getValue());
        }
        if (address != null) {
            queryParams.put("address", address.toHexString(Prefix.ZeroLowerX));
        }
        return sendPostRequest(Path.PostFilterEventsLogPath, null, queryParams, filter, (new ArrayList<FilteredEvent>()).getClass());

    }

    /**
     * Get transfer logs by order and
     *
     * @param filter required {@link TransferFilter} filter.
     * @param order  optional {@link Order} the result order.
     * @return array of {@link FilteredTransfer} could be null.
     * @throws ClientIOException network error
     */
    public static ArrayList<?> filterTransferLogs(TransferFilter filter, Order order) throws IOException {
        if (filter == null) {
            throw ClientArgumentException.exception("filter is null");
        }
        HashMap<String, String> queryParams = new HashMap<>();
        if (order != null) {
            queryParams.put("order", order.getValue());
        }

        return sendPostRequest(Path.PostFilterTransferLogPath, null, queryParams, filter, (new ArrayList<FilteredTransfer>()).getClass());

    }

}
