/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.clients;

import java.io.IOException;
import java.util.ArrayList;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.clients.BlockClient;
import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.core.model.blockchain.Block;
import network.arkane.provider.core.model.clients.BlockRef;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.utils.BlockchainUtils;

public class BlockchainClient
extends AbstractClient {
    public static byte getChainTag() throws IOException {
        Block genesisBlock = BlockClient.getBlock(Revision.create(0L));
        if (genesisBlock == null) {
            throw new RuntimeException(" Get Genesis block error");
        }
        String hexId = genesisBlock.getId();
        if (!BlockchainUtils.isId(hexId)) {
            throw new RuntimeException(" Genesis block id is invalid");
        }
        byte[] bytesId = BytesUtils.toByteArray((String)hexId);
        if (bytesId == null || bytesId.length != 32) {
            throw new RuntimeException(" Genesis block id converted error");
        }
        return bytesId[31];
    }

    public static ArrayList getPeerStatusList() throws IOException {
        return (ArrayList)BlockchainClient.sendGetRequest(AbstractClient.Path.GetNodeInfoPath, null, null, new ArrayList().getClass());
    }

    public static BlockRef getBlockRef(Revision revision) throws IOException {
        Block block = BlockClient.getBlock(revision);
        if (block != null) {
            return block.blockRef();
        }
        return null;
    }
}

