/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.bridge;

import network.arkane.provider.bridge.TransactionGateway;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.core.model.blockchain.TransferResult;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.gateway.VechainGateway;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.sign.domain.SubmittedAndSignedTransactionSignature;
import network.arkane.provider.sign.domain.TransactionSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VechainTransactionGateway
implements TransactionGateway {
    private static final Logger log = LoggerFactory.getLogger(VechainTransactionGateway.class);
    private VechainGateway vechainGateway;

    public VechainTransactionGateway(VechainGateway vechainGateway) {
        this.vechainGateway = vechainGateway;
    }

    public SecretType getType() {
        return SecretType.VECHAIN;
    }

    public Signature submit(TransactionSignature signTransactionResponse) {
        try {
            TransferResult transferResult = this.vechainGateway.sendRawTransaction(signTransactionResponse.getSignedTransaction());
            return SubmittedAndSignedTransactionSignature.signAndSubmitTransactionBuilder().transactionHash(transferResult.getId()).signedTransaction(signTransactionResponse.getSignedTransaction()).build();
        }
        catch (ArkaneException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("Problem trying to send transaction to vechain");
            throw ArkaneException.arkaneException().errorCode("transaction.submit.internal-error").message("problem trying to submit transaction to vechain: " + ex.getMessage()).build();
        }
    }
}

