/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.balance;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import network.arkane.provider.balance.BalanceGateway;
import network.arkane.provider.balance.domain.Balance;
import network.arkane.provider.balance.domain.TokenBalance;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.core.model.blockchain.Account;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.ERC20Token;
import network.arkane.provider.gateway.VechainGateway;
import network.arkane.provider.token.TokenDiscoveryService;
import network.arkane.provider.token.TokenInfo;
import org.springframework.stereotype.Component;

@Component
public class VechainBalanceGateway
implements BalanceGateway {
    private VechainGateway vechainGateway;
    private final TokenDiscoveryService tokenDiscoveryService;

    public VechainBalanceGateway(VechainGateway vechainGateway, TokenDiscoveryService tokenDiscoveryService) {
        this.vechainGateway = vechainGateway;
        this.tokenDiscoveryService = tokenDiscoveryService;
    }

    public SecretType type() {
        return SecretType.VECHAIN;
    }

    public Balance getBalance(String hexAccount) {
        Account account = this.vechainGateway.getAccount(hexAccount);
        return Balance.builder().secretType(SecretType.VECHAIN).balance(account.VETBalance().getAmount().doubleValue()).rawBalance(account.VETBalance().toBigInteger().toString()).gasBalance(account.energyBalance().getAmount().doubleValue()).rawGasBalance(account.energyBalance().toBigInteger().toString()).symbol("VET").gasSymbol("VTHO").decimals(18).build();
    }

    public TokenBalance getTokenBalance(String walletAddress, String tokenAddress) {
        TokenInfo tokenInfo = (TokenInfo)this.tokenDiscoveryService.getTokenInfo(SecretType.VECHAIN, tokenAddress).orElseThrow(IllegalArgumentException::new);
        return this.getTokenBalance(walletAddress, tokenInfo);
    }

    public List<TokenBalance> getTokenBalances(String walletAddress) {
        return this.getTokenBalances(walletAddress, this.tokenDiscoveryService.getTokens(SecretType.VECHAIN));
    }

    private List<TokenBalance> getTokenBalances(String walletAddress, List<TokenInfo> tokenInfo) {
        List<BigInteger> balances = this.vechainGateway.getTokenBalances(walletAddress, tokenInfo.stream().map(TokenInfo::getAddress).collect(Collectors.toList()));
        ArrayList<TokenBalance> results = new ArrayList<TokenBalance>();
        for (int i = 0; i < balances.size(); ++i) {
            TokenInfo token = tokenInfo.get(i);
            results.add(TokenBalance.builder().tokenAddress(token.getAddress()).rawBalance(balances.get(i).toString()).balance(this.calculateBalance(balances.get(i), token)).decimals(token.getDecimals().intValue()).symbol(token.getSymbol()).logo(token.getLogo()).build());
        }
        return results;
    }

    private double calculateBalance(BigInteger tokenBalance, TokenInfo tokenInfo) {
        BigDecimal rawBalance = new BigDecimal(tokenBalance);
        BigDecimal divider = BigDecimal.valueOf(10L).pow(tokenInfo.getDecimals());
        return rawBalance.divide(divider, 6, RoundingMode.HALF_DOWN).doubleValue();
    }

    private TokenBalance getTokenBalance(String walletAddress, TokenInfo tokenInfo) {
        ERC20Token token = ERC20Token.create(tokenInfo.getName(), Address.fromHexString(tokenInfo.getAddress()));
        token.setPrecision(new BigDecimal(tokenInfo.getDecimals()));
        Amount tokenBalance = this.vechainGateway.getTokenBalance(walletAddress, token);
        return TokenBalance.builder().tokenAddress(tokenInfo.getAddress()).balance(tokenBalance.getAmount() == null ? 0.0 : tokenBalance.getAmount().doubleValue()).rawBalance(tokenBalance.getAmount() == null ? "0" : tokenBalance.toBigInteger().toString()).decimals(tokenInfo.getDecimals().intValue()).symbol(tokenInfo.getSymbol()).logo(tokenInfo.getLogo()).build();
    }
}

