/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.clients;

import java.io.IOException;
import java.util.HashMap;
import network.arkane.provider.Prefix;
import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.core.model.blockchain.Account;
import network.arkane.provider.core.model.blockchain.AccountCode;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.blockchain.ContractCallResult;
import network.arkane.provider.core.model.blockchain.StorageData;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.StorageKey;
import network.arkane.provider.core.model.exception.ClientArgumentException;

public class AccountClient
extends AbstractClient {
    public static Account getAccountInfo(Address address, Revision revision) throws IOException {
        if (address == null) {
            throw ClientArgumentException.exception("Address account is null");
        }
        Revision currRevision = revision;
        if (currRevision == null) {
            currRevision = Revision.BEST;
        }
        HashMap<String, String> uriParams = AccountClient.parameters(new String[]{"address"}, new String[]{address.toHexString(Prefix.ZeroLowerX)});
        HashMap<String, String> queryParams = AccountClient.parameters(new String[]{"revision"}, new String[]{currRevision.toString()});
        return AccountClient.sendGetRequest(AbstractClient.Path.GetAccountPath, uriParams, queryParams, Account.class);
    }

    public static ContractCallResult deployContractInfo(ContractCall contractCall) throws IOException {
        if (contractCall == null) {
            throw ClientArgumentException.exception("contract call object is null");
        }
        return AccountClient.sendPostRequest(AbstractClient.Path.PostDeployContractPath, null, null, contractCall, ContractCallResult.class);
    }

    public static AccountCode getAccountCode(Address address, Revision revision) throws IOException {
        if (address == null) {
            throw ClientArgumentException.exception("Address account is null");
        }
        Revision currRevision = revision;
        if (currRevision == null) {
            currRevision = Revision.BEST;
        }
        HashMap<String, String> uriParams = AccountClient.parameters(new String[]{"address"}, new String[]{address.toHexString(Prefix.ZeroLowerX)});
        HashMap<String, String> queryParams = AccountClient.parameters(new String[]{"revision"}, new String[]{currRevision.toString()});
        return AccountClient.sendGetRequest(AbstractClient.Path.GetAccountCodePath, uriParams, queryParams, AccountCode.class);
    }

    public static StorageData getStorageAt(Address address, StorageKey key, Revision revision) throws IOException {
        if (address == null) {
            throw ClientArgumentException.exception("Address account is null");
        }
        if (key == null) {
            throw ClientArgumentException.exception("key is null");
        }
        Revision currRevision = revision;
        if (currRevision == null) {
            currRevision = Revision.BEST;
        }
        HashMap<String, String> uriParams = AccountClient.parameters(new String[]{"address", "key"}, new String[]{address.toHexString(Prefix.ZeroLowerX), key.hexKey()});
        HashMap<String, String> queryParams = AccountClient.parameters(new String[]{"revision"}, new String[]{currRevision.toString()});
        return AccountClient.sendGetRequest(AbstractClient.Path.GetStorageValuePath, uriParams, queryParams, StorageData.class);
    }
}

