/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.core.model.clients.ERC20Token;
import network.arkane.provider.core.model.clients.base.AbstractToken;
import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.utils.BlockchainUtils;
import network.arkane.provider.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Amount {
    private static final Logger log = LoggerFactory.getLogger(Amount.class);
    public static final Amount ZERO = new Zero();
    private AbstractToken abstractToken;
    private BigDecimal amount;

    public static Amount createFromToken(AbstractToken token) {
        Amount amount = new Amount();
        amount.abstractToken = token;
        return amount;
    }

    public static Amount VET() {
        return Amount.createFromToken(AbstractToken.VET);
    }

    public static Amount VTHO() {
        return Amount.createFromToken(ERC20Token.VTHO);
    }

    private Amount() {
    }

    public Amount setHexAmount(String hexAmount) {
        String noPrefixAmount = StringUtils.sanitizeHex(hexAmount);
        if (StringUtils.isBlank(noPrefixAmount)) {
            return this;
        }
        if (!StringUtils.isHex(hexAmount)) {
            log.error("{} is not a hex amount", (Object)hexAmount);
            throw ClientArgumentException.exception("setHexValue argument hex value.");
        }
        this.amount = BlockchainUtils.amount(noPrefixAmount, this.abstractToken.getPrecision().intValue(), this.abstractToken.getScale().intValue());
        return this;
    }

    public Amount setDecimalAmount(String decimalAmount) {
        if (StringUtils.isBlank(decimalAmount)) {
            throw new IllegalArgumentException("Decimal amount string is blank");
        }
        this.amount = new BigDecimal(decimalAmount);
        return this;
    }

    public Amount setBigIntegerAmount(BigInteger bigIntegerAmount) {
        this.amount = new BigDecimal(bigIntegerAmount).divide(BigDecimal.TEN.pow(this.abstractToken.getPrecision().intValue()), this.abstractToken.getPrecision().intValue(), RoundingMode.HALF_DOWN);
        return this;
    }

    public String toHexString() {
        BigDecimal fullDecimal = this.amount.multiply(BigDecimal.TEN.pow(this.abstractToken.getPrecision().intValue()));
        byte[] bytes = BytesUtils.trimLeadingZeroes((byte[])fullDecimal.toBigInteger().toByteArray());
        return BytesUtils.toHexString((byte[])bytes, (Prefix)Prefix.ZeroLowerX);
    }

    public BigInteger toBigInteger() {
        BigDecimal fullDecimal = this.amount.multiply(BigDecimal.TEN.pow(this.abstractToken.getPrecision().intValue()));
        return fullDecimal.toBigInteger();
    }

    public AbstractToken getAbstractToken() {
        return this.abstractToken;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public byte[] toByteArray() {
        return BlockchainUtils.byteArrayAmount(this.amount, this.abstractToken.getPrecision().intValue());
    }

    private static class Zero
    extends Amount {
        private Zero() {
        }

        @Override
        public byte[] toByteArray() {
            return new byte[0];
        }

        @Override
        public BigDecimal getAmount() {
            return new BigDecimal(0);
        }
    }
}

