/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.RawTransaction;
import network.arkane.provider.utils.CryptoUtils;
import network.arkane.provider.utils.RLPUtils;
import network.arkane.provider.utils.StringUtils;
import network.arkane.provider.utils.crypto.ECDSASign;
import network.arkane.provider.utils.crypto.ECDSASignature;
import network.arkane.provider.utils.crypto.ECKeyPair;

public class BlockchainUtils {
    public static boolean isValidRevision(String revision) {
        String blockNumPattern = "^[0-9]\\d*$";
        if (StringUtils.isBlank(revision)) {
            return false;
        }
        if (StringUtils.isHex(revision) && revision.length() == 66) {
            return true;
        }
        if (Pattern.matches(blockNumPattern, revision)) {
            return true;
        }
        return "best".equalsIgnoreCase(revision);
    }

    public static boolean isAddress(String address) {
        return StringUtils.isCriticalHex(address) && address.length() == 42;
    }

    public static boolean isId(String hexId) {
        return !StringUtils.isBlank(hexId) && StringUtils.isHex(hexId) && hexId.length() == 66;
    }

    public static boolean checkSumAddress(String address) {
        String checkSumAddress = BlockchainUtils.getChecksumAddress(address);
        return address.equals(checkSumAddress);
    }

    public static boolean checkSumAddress(String address, boolean isCheck) {
        boolean rtn = false;
        if (address != null && address.length() == 42 && address.toLowerCase().matches("0x[A-Fa-f0-9]{40}")) {
            if (isCheck) {
                String realAddress = address.substring(2);
                rtn = BlockchainUtils.checkSumAddress(realAddress);
            } else {
                rtn = true;
            }
        }
        return rtn;
    }

    public static String getChecksumAddress(String address) {
        address = BytesUtils.cleanHexPrefix((String)address);
        address = address.toLowerCase();
        byte[] bytes = CryptoUtils.keccak256(address.getBytes());
        StringBuffer buffer = new StringBuffer();
        String hex = BytesUtils.toHexString((byte[])bytes, null);
        char[] chars = hex.toCharArray();
        int size = address.length();
        char[] raws = address.toCharArray();
        for (int i = 0; i < size; ++i) {
            if (BlockchainUtils.parseInt(chars[i]) >= 8) {
                buffer.append(("" + raws[i]).toUpperCase());
                continue;
            }
            buffer.append(raws[i]);
        }
        return "0x" + buffer.toString();
    }

    public static String fillZeroBefore(String s, int length) {
        for (int i = 0; i < length && (s = "0" + s).length() < length; ++i) {
        }
        return s;
    }

    private static int parseInt(char value) {
        if (value >= 'a' && value <= 'f') {
            return 9 + (value - 97 + 1);
        }
        return value - 48;
    }

    public static BigDecimal amount(String hexString, int precision, int scale) {
        byte[] balBytes = BytesUtils.toByteArray((String)hexString);
        if (balBytes == null) {
            return null;
        }
        BigInteger balInteger = BytesUtils.bytesToBigInt((byte[])balBytes);
        return BytesUtils.bigIntToBigDecimal((BigInteger)balInteger, (int)precision, (int)scale);
    }

    public static byte[] byteArrayAmount(BigDecimal amount, int precision) {
        if (amount == null) {
            throw new IllegalArgumentException("amount is null");
        }
        if (precision < 0) {
            throw new IllegalArgumentException("precision is invalid");
        }
        BigDecimal bigDecimal = amount.multiply(BigDecimal.TEN.pow(precision));
        BigInteger bigInt = bigDecimal.toBigInteger();
        return BytesUtils.trimLeadingZeroes((byte[])bigInt.toByteArray());
    }

    public static ECKeyPair recoverPublicKey(String rawTransactionHex) {
        if (StringUtils.isBlank(rawTransactionHex)) {
            return null;
        }
        RawTransaction rawTransaction = RLPUtils.decode(rawTransactionHex);
        if (rawTransaction == null) {
            return null;
        }
        RawTransaction newRawTransaction = rawTransaction.copy();
        newRawTransaction.setSignature(null);
        byte[] signature = rawTransaction.getSignature();
        if (signature == null || signature.length != 65) {
            return null;
        }
        byte[] rlpTxRaw = RLPUtils.encodeRawTransaction(newRawTransaction);
        byte[] rBytes = new byte[32];
        byte[] sBytes = new byte[32];
        System.arraycopy(signature, 0, rBytes, 0, rBytes.length);
        System.arraycopy(signature, 32, sBytes, 0, sBytes.length);
        byte recovery = signature[64];
        byte[] signingHash = CryptoUtils.blake2b(rlpTxRaw);
        ECDSASignature ecdsaSignature = new ECDSASignature(rBytes, sBytes);
        BigInteger publicKey = ECDSASign.recoverFromSignature(recovery, ecdsaSignature, signingHash);
        return new ECKeyPair(null, publicKey);
    }

    public static String generateTransactionId(RawTransaction rawTransaction, Address signer) {
        if (rawTransaction == null || signer == null) {
            return null;
        }
        RawTransaction copyRawTransaction = rawTransaction.copy();
        copyRawTransaction.setSignature(null);
        byte[] rlp = RLPUtils.encodeRawTransaction(copyRawTransaction);
        byte[] signHash = CryptoUtils.blake2b(rlp);
        return BlockchainUtils.generateTransactionId(signHash, signer);
    }

    public static String generateTransactionId(byte[] signingHash, Address signer) {
        if (signingHash == null || signer == null) {
            return null;
        }
        byte[] concatenatedBytes = new byte[52];
        System.arraycopy(signingHash, 0, concatenatedBytes, 0, signingHash.length);
        System.arraycopy(signer.toByteArray(), 0, concatenatedBytes, signingHash.length, signer.toByteArray().length);
        byte[] txIdBytes = CryptoUtils.blake2b(concatenatedBytes);
        return BytesUtils.toHexString((byte[])txIdBytes, (Prefix)Prefix.ZeroLowerX);
    }
}

