/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BeanRefUtils {
    public static Map<String, String> getFieldValueMap(Object bean) {
        Field[] fields;
        Class<?> cls = bean.getClass();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                String fieldType = field.getType().getSimpleName();
                String fieldGetName = BeanRefUtils.parGetName(field.getName());
                if (!BeanRefUtils.checkGetMet(methods, fieldGetName)) continue;
                Method fieldGetMet = cls.getMethod(fieldGetName, new Class[0]);
                Object fieldVal = fieldGetMet.invoke(bean, new Object[0]);
                String result = null;
                if ("Date".equals(fieldType)) {
                    result = BeanRefUtils.fmtDate((Date)fieldVal);
                } else if (null != fieldVal) {
                    result = String.valueOf(fieldVal);
                }
                valueMap.put(field.getName(), result);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return valueMap;
    }

    public static void setFieldValue(Object bean, Map<String, Object> valMap) {
        Field[] fields;
        Class<?> cls = bean.getClass();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                String fieldSetName = BeanRefUtils.parSetName(field.getName());
                if (!BeanRefUtils.checkSetMet(methods, fieldSetName)) continue;
                Method fieldSetMet = cls.getMethod(fieldSetName, field.getType());
                String fieldKeyName = field.getName();
                Object value = valMap.get(fieldKeyName);
                if (null == value || "".equals(value)) continue;
                String fieldType = field.getType().getSimpleName();
                if ("String".equals(fieldType)) {
                    fieldSetMet.invoke(bean, value);
                    continue;
                }
                if ("Date".equals(fieldType)) {
                    Date temp = BeanRefUtils.parseDate(value.toString());
                    fieldSetMet.invoke(bean, temp);
                    continue;
                }
                if ("Integer".equals(fieldType) || "int".equals(fieldType)) {
                    Integer intval = Integer.parseInt(value.toString());
                    fieldSetMet.invoke(bean, intval);
                    continue;
                }
                if ("Long".equalsIgnoreCase(fieldType)) {
                    Long temp = Long.parseLong(value.toString());
                    fieldSetMet.invoke(bean, temp);
                    continue;
                }
                if ("Double".equalsIgnoreCase(fieldType)) {
                    Double temp = Double.parseDouble(value.toString());
                    fieldSetMet.invoke(bean, temp);
                    continue;
                }
                if ("Boolean".equalsIgnoreCase(fieldType)) {
                    Boolean temp = Boolean.parseBoolean(value.toString());
                    fieldSetMet.invoke(bean, temp);
                    continue;
                }
                if ("byte[]".equalsIgnoreCase(fieldType) && value instanceof byte[]) {
                    byte[] temp = (byte[])value;
                    fieldSetMet.invoke(bean, new Object[]{temp});
                    continue;
                }
                if ("Byte".equalsIgnoreCase(fieldType)) {
                    byte temp = Byte.parseByte(value.toString());
                    fieldSetMet.invoke(bean, temp);
                    continue;
                }
                System.out.println("not support type" + fieldType);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Date parseDate(String datestr) {
        if (null == datestr || "".equals(datestr)) {
            return null;
        }
        try {
            String fmtstr = null;
            fmtstr = datestr.indexOf(58) > 0 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(fmtstr, Locale.UK);
            return sdf.parse(datestr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fmtDate(Date date) {
        if (null == date) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            return sdf.format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean checkSetMet(Method[] methods, String fieldSetMet) {
        for (Method met : methods) {
            if (!fieldSetMet.equals(met.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkGetMet(Method[] methods, String fieldGetMet) {
        for (Method met : methods) {
            if (!fieldGetMet.equals(met.getName())) continue;
            return true;
        }
        return false;
    }

    public static String parGetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_') {
            startIndex = 1;
        }
        return "get" + fieldName.substring(startIndex, startIndex + 1).toUpperCase() + fieldName.substring(startIndex + 1);
    }

    public static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_') {
            startIndex = 1;
        }
        return "set" + fieldName.substring(startIndex, startIndex + 1).toUpperCase() + fieldName.substring(startIndex + 1);
    }

    public static String parKeyName(String fieldName) {
        String fieldGetName = BeanRefUtils.parGetName(fieldName);
        if (fieldGetName != null && fieldGetName.trim() != "" && fieldGetName.length() > 3) {
            return fieldGetName.substring(3);
        }
        return fieldGetName;
    }
}

