/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.math.BigInteger;
import java.util.List;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.clients.BlockchainClient;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.RawTransaction;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.ToClause;
import network.arkane.provider.core.model.clients.ToData;
import network.arkane.provider.secret.generation.VechainSecretKey;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.VechainTransactionSignable;
import network.arkane.provider.sign.VechainTransactionSignableToClause;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.sign.domain.TransactionSignature;
import network.arkane.provider.utils.CryptoUtils;
import network.arkane.provider.utils.RawTransactionFactory;
import network.arkane.provider.utils.crypto.ECDSASign;
import network.arkane.provider.utils.crypto.ECKeyPair;
import network.arkane.provider.wallet.extraction.VechainKeystoreExtractor;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.stereotype.Component;

@Component
public class VechainTransactionSigner
implements Signer<VechainTransactionSignable, VechainSecretKey> {
    private VechainKeystoreExtractor vechainKeystoreExtractor;

    public VechainTransactionSigner(VechainKeystoreExtractor vechainKeystoreExtractor) {
        this.vechainKeystoreExtractor = vechainKeystoreExtractor;
    }

    public Signature createSignature(VechainTransactionSignable signable, VechainSecretKey key) {
        RawTransaction rawTransaction = this.constructTransaction(signable);
        ECDSASign.SignatureData signature = ECDSASign.signMessage(rawTransaction.encode(), ECKeyPair.create(key.getKeyPair().getPrivateKey()), true);
        rawTransaction.setSignature(signature.toByteArray());
        String fullSignBytes = BytesUtils.toHexString((byte[])rawTransaction.encode(), (Prefix)Prefix.ZeroLowerX);
        return TransactionSignature.signTransactionBuilder().signedTransaction(fullSignBytes).build();
    }

    public VechainSecretKey reconstructKey(String secret, String password) {
        return null;
    }

    public Class<VechainTransactionSignable> getType() {
        return VechainTransactionSignable.class;
    }

    private RawTransaction constructTransaction(VechainTransactionSignable signable) {
        Byte chainTag = StringUtils.isEmpty((CharSequence)signable.getChainTag()) ? this.getChainTag() : Byte.valueOf(signable.getChainTag()).byteValue();
        byte[] blockRef = StringUtils.isEmpty((CharSequence)signable.getBlockRef()) ? this.getBlockRef() : Hex.decode((String)signable.getBlockRef());
        byte[] nonce = StringUtils.isEmpty((CharSequence)signable.getNonce()) ? CryptoUtils.generateTxNonce() : Hex.decode((String)signable.getNonce());
        return RawTransactionFactory.getInstance().createRawTransaction(chainTag, blockRef, this.getExpiration(signable), signable.getGas(), (byte)signable.getGasPriceCoef().intValue(), nonce, this.convert(signable.getClauses()));
    }

    private int getExpiration(VechainTransactionSignable signable) {
        return signable.getExpiration() <= 0 ? 720 : signable.getExpiration();
    }

    private byte getChainTag() {
        try {
            return BlockchainClient.getChainTag();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to fetch chainTag");
        }
    }

    private byte[] getBlockRef() {
        try {
            return BlockchainClient.getBlockRef(Revision.BEST).toByteArray();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to fetch block ref");
        }
    }

    private ToClause[] convert(List<VechainTransactionSignableToClause> clauses) {
        return (ToClause[])clauses.stream().map(x -> {
            ToData data;
            Amount vet = Amount.VET();
            if (x.getAmount() == null || x.getAmount().compareTo(BigInteger.ZERO) == 0) {
                vet = Amount.ZERO;
            } else {
                vet.setBigIntegerAmount(x.getAmount());
            }
            if (x.getData() != null) {
                data = new ToData();
                data.setData(x.getData());
            } else {
                data = ToData.ZERO;
            }
            return new ToClause(Address.fromHexString(x.getTo()), vet, data);
        }).toArray(ToClause[]::new);
    }
}

