/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.gateway;

import java.math.BigInteger;
import java.util.List;
import network.arkane.provider.Prefix;
import network.arkane.provider.clients.AccountClient;
import network.arkane.provider.clients.DeltaBalancesContractClient;
import network.arkane.provider.clients.ERC20ContractClient;
import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.core.model.blockchain.Account;
import network.arkane.provider.core.model.blockchain.TransferRequest;
import network.arkane.provider.core.model.blockchain.TransferResult;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Amount;
import network.arkane.provider.core.model.clients.ERC20Token;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.exceptions.ArkaneException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VechainGateway {
    private static final Logger log = LoggerFactory.getLogger(VechainGateway.class);
    private DeltaBalancesContractClient deltaBalancesContractClient;

    public VechainGateway(DeltaBalancesContractClient deltaBalancesContractClient) {
        this.deltaBalancesContractClient = deltaBalancesContractClient;
    }

    public Account getAccount(String account) {
        try {
            return AccountClient.getAccountInfo(Address.fromHexString(account), Revision.BEST);
        }
        catch (Exception ex) {
            log.error("Problem trying to get account from the Vechain network");
            throw ArkaneException.arkaneException().errorCode("thorify.internal-error").message(String.format("Unable to get the properties for the specified account (%s) (vechain)", account)).build();
        }
    }

    public Amount getTokenBalance(String owner, ERC20Token token) {
        try {
            return ERC20ContractClient.getERC20Balance(Address.fromHexString(owner), token, Revision.BEST);
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the token balance of %s for token %s", owner, token.getContractAddress().toHexString(Prefix.ZeroLowerX)));
            throw ArkaneException.arkaneException().errorCode("thorify.internal-error").message(String.format("Problem trying to get the token balance of %s for token %s (vechain)", owner, token.getContractAddress().toHexString(Prefix.ZeroLowerX))).build();
        }
    }

    public List<BigInteger> getTokenBalances(String owner, List<String> tokenAddresses) {
        try {
            return this.deltaBalancesContractClient.getVip180Balances(Address.fromHexString(owner), tokenAddresses);
        }
        catch (Exception ex) {
            throw ArkaneException.arkaneException().errorCode("thorify.internal-error").message(String.format("Problem trying to get the token balances of %s (vechain)", owner)).build();
        }
    }

    public String getTokenName(String tokenAddress) {
        try {
            return ERC20ContractClient.name(Address.fromHexString(tokenAddress));
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the name for token %s (VeChain)", tokenAddress));
            throw ArkaneException.arkaneException().errorCode("thorify.internal-error").message(String.format("Problem trying to get the name for token %s (VeChain)", tokenAddress)).build();
        }
    }

    public String getTokenSymbol(String tokenAddress) {
        try {
            return ERC20ContractClient.symbol(Address.fromHexString(tokenAddress));
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the symbol for token %s (VeChain)", tokenAddress));
            throw ArkaneException.arkaneException().errorCode("thorify.internal-error").message(String.format("Problem trying to get the symbol for token %s (VeChain)", tokenAddress)).build();
        }
    }

    public BigInteger getTokenDecimals(String tokenAddress) {
        try {
            return ERC20ContractClient.decimals(Address.fromHexString(tokenAddress));
        }
        catch (Exception ex) {
            log.error(String.format("Problem trying to get the decimals for token %s (VeChain)", tokenAddress));
            throw ArkaneException.arkaneException().errorCode("thorify.internal-error").message(String.format("Problem trying to get the decimals for token %s (VeChain)", tokenAddress)).build();
        }
    }

    public TransferResult sendRawTransaction(String signedTransaction) {
        TransferRequest request = new TransferRequest();
        request.setRaw(signedTransaction);
        try {
            return AbstractClient.sendPostRequest(AbstractClient.Path.PostTransaction, null, null, request, TransferResult.class);
        }
        catch (Exception ex) {
            log.error("Problem trying to submit transaction to the Vechain network: {}", (Object)ex.getMessage());
            if (ex.getMessage() != null && ex.getMessage().contains("insufficient energy")) {
                throw ArkaneException.arkaneException().errorCode("transaction.insufficient-funds").message("The account that initiated the transfer does not have enough energy").cause((Throwable)ex).build();
            }
            throw ArkaneException.arkaneException().errorCode("thorify.transaction.submit.internal-error").message("A problem occurred trying to submit the transaction to the Vechain network").cause((Throwable)ex).build();
        }
    }
}

