/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.generation;

import network.arkane.provider.chain.SecretType;
import network.arkane.provider.secret.generation.VechainSecretKey;
import network.arkane.provider.wallet.domain.SecretKey;
import network.arkane.provider.wallet.generation.AbstractWalletGenerator;
import network.arkane.provider.wallet.generation.GeneratedVechainWallet;
import network.arkane.provider.wallet.generation.GeneratedWallet;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class VechainWalletGenerator
implements AbstractWalletGenerator {
    public GeneratedWallet generateWallet(String password, SecretKey secret) {
        if (StringUtils.isEmpty((Object)password)) {
            throw new IllegalArgumentException("Password should not be empty");
        }
        VechainSecretKey ethereumSecret = (VechainSecretKey)secret;
        try {
            WalletFile theWallet = Wallet.createStandard((String)password, (ECKeyPair)((VechainSecretKey)secret).getKeyPair());
            return GeneratedVechainWallet.builder().walletFile(theWallet).address(this.getAddress(ethereumSecret)).build();
        }
        catch (CipherException e) {
            throw new IllegalArgumentException("Unable to generate a wallet from the provided keypair");
        }
    }

    private String getAddress(VechainSecretKey vechainSecretKey) {
        return Keys.toChecksumAddress((String)Keys.getAddress((ECKeyPair)vechainSecretKey.getKeyPair()));
    }

    public SecretType type() {
        return SecretType.VECHAIN;
    }
}

