/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.extraction;

import network.arkane.provider.secret.generation.VechainSecretKey;
import network.arkane.provider.wallet.domain.SecretKey;
import network.arkane.provider.wallet.extraction.AbstractSecretExtractor;
import network.arkane.provider.wallet.extraction.request.PrivateKeyExtractionRequest;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;

@Component
public class VechainPrivateKeyExtractor
implements AbstractSecretExtractor<PrivateKeyExtractionRequest> {
    private static final Logger log = LoggerFactory.getLogger(VechainPrivateKeyExtractor.class);

    public SecretKey extract(PrivateKeyExtractionRequest importWalletRequest) {
        try {
            String sanitizedKey = this.sanitize(importWalletRequest.getPrivateKey());
            return VechainSecretKey.builder().keyPair(ECKeyPair.create((byte[])Hex.decodeHex((String)sanitizedKey))).build();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to decode ethereum private key " + importWalletRequest.getPrivateKey());
        }
    }

    private String sanitize(String privateKey) {
        if (privateKey != null && privateKey.startsWith("0x")) {
            return privateKey.substring(2);
        }
        return privateKey;
    }

    public Class<PrivateKeyExtractionRequest> getImportRequestType() {
        return PrivateKeyExtractionRequest.class;
    }
}

