/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.bridge;

import java.math.BigInteger;
import java.util.Optional;
import network.arkane.provider.bridge.BlockchainBridge;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.core.model.blockchain.TransferResult;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.gateway.VechainGateway;
import network.arkane.provider.signature.Signature;
import network.arkane.provider.signature.SubmittedAndSignedTransactionSignature;
import network.arkane.provider.signature.TransactionSignature;
import network.arkane.provider.token.TokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class VechainBridge
implements BlockchainBridge {
    private static final Logger log = LoggerFactory.getLogger(VechainBridge.class);
    private VechainGateway vechainGateway;
    private ApplicationEventPublisher applicationEventPublisher;

    public VechainBridge(VechainGateway vechainGateway, ApplicationEventPublisher applicationEventPublisher) {
        this.vechainGateway = vechainGateway;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public SecretType getType() {
        return SecretType.VECHAIN;
    }

    public Signature submit(TransactionSignature signTransactionResponse) {
        try {
            TransferResult transferResult = this.vechainGateway.sendRawTransaction(signTransactionResponse.getSignedTransaction());
            return SubmittedAndSignedTransactionSignature.signAndSubmitTransactionBuilder().transactionHash(transferResult.getId()).signedTransaction(signTransactionResponse.getSignedTransaction()).build();
        }
        catch (ArkaneException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("Problem trying to send transaction to vechain");
            throw ArkaneException.arkaneException().errorCode("transaction.submit.internal-error").message("problem trying to submit transaction to vechain: " + ex.getMessage()).build();
        }
    }

    public Optional<TokenInfo> getTokenInfo(String tokenAddress) {
        String name = this.vechainGateway.getTokenName(tokenAddress);
        String symbol = this.vechainGateway.getTokenSymbol(tokenAddress);
        BigInteger decimals = this.vechainGateway.getTokenDecimals(tokenAddress);
        if (name != null && decimals != null && symbol != null) {
            return Optional.of(TokenInfo.builder().address(tokenAddress).name(name).decimals(Integer.valueOf(decimals.intValue())).symbol(symbol).type("VIP180").build());
        }
        return Optional.empty();
    }
}

