/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.nonfungable;

import java.util.List;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.nonfungable.OpenSeaAssetToNonFungibleAssetMapper;
import network.arkane.provider.nonfungable.OpenSeaContractToNonFungibleContractMapper;
import network.arkane.provider.nonfungible.NonFungibleGateway;
import network.arkane.provider.nonfungible.domain.NonFungibleAsset;
import network.arkane.provider.nonfungible.domain.NonFungibleContract;
import network.arkane.provider.opensea.OpenSeaGateway;
import org.springframework.stereotype.Service;

@Service
public class EthereumNonFungibleGateway
implements NonFungibleGateway {
    private final OpenSeaGateway openSeaGateway;
    private final OpenSeaAssetToNonFungibleAssetMapper mapper;
    private final OpenSeaContractToNonFungibleContractMapper contractMapper;

    public EthereumNonFungibleGateway(OpenSeaGateway openSeaGateway, OpenSeaAssetToNonFungibleAssetMapper mapper, OpenSeaContractToNonFungibleContractMapper contractMapper) {
        this.openSeaGateway = openSeaGateway;
        this.mapper = mapper;
        this.contractMapper = contractMapper;
    }

    public SecretType getSecretType() {
        return SecretType.ETHEREUM;
    }

    public List<NonFungibleAsset> listNonFungibles(String walletId, String ... contractAddresses) {
        return this.mapper.mapToList(this.openSeaGateway.listAssets(walletId, contractAddresses));
    }

    public NonFungibleAsset getNonFungible(String contractAddress, String tokenId) {
        return this.mapper.map(this.openSeaGateway.getAsset(contractAddress, tokenId));
    }

    public NonFungibleContract getNonFungibleContract(String contractAddress) {
        return this.contractMapper.map(this.openSeaGateway.getContract(contractAddress));
    }
}

