/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.gateway;

import network.arkane.provider.gateway.EthereumWeb3JGateway;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

@Component
public class EthereumWeb3JGatewayFactory {
    private final EthereumWeb3JGateway defaultEthereumGateway;
    private final String deltaBalancesAddress;

    public EthereumWeb3JGatewayFactory(@Qualifier(value="ethereumWeb3j") Web3j ethereumWeb3j, @Value(value="${network.arkane.ethereum.deltabalances.contract-address}") String deltaBalancesAddress) {
        this.deltaBalancesAddress = deltaBalancesAddress;
        this.defaultEthereumGateway = new EthereumWeb3JGateway(ethereumWeb3j, deltaBalancesAddress);
    }

    public EthereumWeb3JGateway getInstance() {
        return this.defaultEthereumGateway;
    }

    public EthereumWeb3JGateway getInstance(String endpoint) {
        if (StringUtils.isBlank((CharSequence)endpoint)) {
            return this.defaultEthereumGateway;
        }
        return new EthereumWeb3JGateway(Web3j.build((Web3jService)new HttpService(endpoint, false)), this.deltaBalancesAddress);
    }
}

