/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.bridge;

import java.util.Optional;
import network.arkane.provider.bridge.TransactionGateway;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.sign.domain.SubmittedAndSignedTransactionSignature;
import network.arkane.provider.sign.domain.TransactionSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.http.HttpService;

@Service
public class EthereumTransactionGateway
implements TransactionGateway {
    private static final Logger log = LoggerFactory.getLogger(EthereumTransactionGateway.class);
    private Web3j defaultWeb3j;

    public EthereumTransactionGateway(@Qualifier(value="ethereumWeb3j") Web3j web3j) {
        this.defaultWeb3j = web3j;
    }

    public SecretType getType() {
        return SecretType.ETHEREUM;
    }

    public Signature submit(TransactionSignature signTransactionResponse, Optional<String> endpoint) {
        try {
            log.debug("Sending transaction to ethereum node {}", (Object)signTransactionResponse.getSignedTransaction());
            Web3j web3j = endpoint.map(this::createWeb3j).orElse(this.defaultWeb3j);
            EthSendTransaction send = this.ethSendRawTransaction(web3j, signTransactionResponse.getSignedTransaction());
            if (send.hasError()) {
                if (send.getError().getMessage().matches(".*[I,i]nsufficient funds.*")) {
                    log.warn("Got error from ethereum chain: insufficient funds");
                    throw ArkaneException.arkaneException().errorCode("transaction.insufficient-funds").message("The account that initiated the transfer does not have enough energy").build();
                }
                log.error("Got error from ethereum chain: {}", (Object)send.getError().getMessage());
                throw ArkaneException.arkaneException().errorCode("transaction.submit.ethereum-error").build();
            }
            return SubmittedAndSignedTransactionSignature.signAndSubmitTransactionBuilder().transactionHash(send.getTransactionHash()).signedTransaction(signTransactionResponse.getSignedTransaction()).build();
        }
        catch (ArkaneException ex) {
            log.debug("Exception submitting transaction", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Error trying to submit a signed transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.submit.internal-error").message("A problem occurred trying to submit the transaction to the Ethereum network").cause((Throwable)ex).build();
        }
    }

    private Web3j createWeb3j(@Value(value="${network.arkane.ethereum.endpoint.url}") String endpoint) {
        return Web3j.build((Web3jService)new HttpService(endpoint, false));
    }

    private EthSendTransaction ethSendRawTransaction(Web3j web3j, String signedTransaction) {
        try {
            return (EthSendTransaction)web3j.ethSendRawTransaction(signedTransaction).send();
        }
        catch (Exception ex) {
            log.error("Problem trying to submit transaction to the Ethereum network: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("web3j.transaction.submit.internal-error").message("A problem occurred trying to submit the transaction to the Ethereum network").cause((Throwable)ex).build();
        }
    }
}

