/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.generation;

import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.wallet.generation.GeneratedEthereumWallet;
import network.arkane.provider.wallet.generation.GeneratedWallet;
import network.arkane.provider.wallet.generation.WalletGenerator;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class EthereumWalletGenerator
implements WalletGenerator<EthereumSecretKey> {
    public GeneratedWallet generateWallet(String password, EthereumSecretKey secret) {
        if (StringUtils.isEmpty((Object)password)) {
            throw new IllegalArgumentException("Password should not be empty");
        }
        try {
            WalletFile theWallet = Wallet.createStandard((String)password, (ECKeyPair)secret.getKeyPair());
            return GeneratedEthereumWallet.builder().walletFile(theWallet).address(this.getAddress(secret)).build();
        }
        catch (CipherException e) {
            throw new IllegalArgumentException("Unable to generate a wallet from the provided keypair");
        }
    }

    private String getAddress(EthereumSecretKey ethereumSecret) {
        return Keys.toChecksumAddress((String)Keys.getAddress((ECKeyPair)ethereumSecret.getKeyPair()));
    }
}

