/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.exporting;

import network.arkane.provider.JSONUtil;
import network.arkane.provider.chain.SecretType;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.wallet.decryption.EthereumWalletDecryptor;
import network.arkane.provider.wallet.exporting.KeyExporter;
import network.arkane.provider.wallet.generation.GeneratedEthereumWallet;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;

@Component
public class EthereumKeystoreExporter
implements KeyExporter<EthereumSecretKey> {
    private EthereumWalletDecryptor ethereumWalletDecryptor;

    public EthereumKeystoreExporter(EthereumWalletDecryptor ethereumWalletDecryptor) {
        this.ethereumWalletDecryptor = ethereumWalletDecryptor;
    }

    public String export(EthereumSecretKey key, String password) {
        try {
            return JSONUtil.toJson((Object)Wallet.createStandard((String)password, (ECKeyPair)key.getKeyPair()));
        }
        catch (Exception ex) {
            throw ArkaneException.arkaneException().errorCode("export.ethereum").message("An error occurred while trying to export the key").build();
        }
    }

    public EthereumSecretKey reconstructKey(String secret, String password) {
        return this.ethereumWalletDecryptor.generateKey(GeneratedEthereumWallet.builder().walletFile((WalletFile)JSONUtil.fromJson((String)secret, WalletFile.class)).build(), password);
    }

    public SecretType type() {
        return SecretType.ETHEREUM;
    }
}

