/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.math.BigInteger;
import java.util.Arrays;
import network.arkane.provider.sign.EthereumRawVerifiable;
import network.arkane.provider.sign.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@Component
public class EthereumRawVerifier
implements Verifier<EthereumRawVerifiable> {
    private static final Logger log = LoggerFactory.getLogger(EthereumRawVerifier.class);
    public static final String MESSAGE_PREFIX = "\u0019Ethereum Signed Message:\n";

    public boolean isValidSignature(EthereumRawVerifiable verifiable) {
        try {
            return this.verifyMessage(verifiable);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean verifyMessage(EthereumRawVerifiable verifiable) {
        String address = verifiable.getAddress();
        String message = verifiable.getMessage();
        if (!address.startsWith("0x")) {
            address = "0x" + address;
        }
        if (verifiable.isPrefix()) {
            String prefix = MESSAGE_PREFIX + message.length();
            message = prefix + message;
        }
        byte[] msgHash = Hash.sha3((byte[])message.getBytes());
        byte[] signatureBytes = Numeric.hexStringToByteArray((String)verifiable.getSignature());
        byte v = signatureBytes[64];
        if (v < 27) {
            v = (byte)(v + 27);
        }
        Sign.SignatureData sd = new Sign.SignatureData(v, Arrays.copyOfRange(signatureBytes, 0, 32), Arrays.copyOfRange(signatureBytes, 32, 64));
        String addressRecovered = null;
        boolean match = false;
        for (int i = 0; i < 4; ++i) {
            BigInteger publicKey = Sign.recoverFromSignature((int)((byte)i), (ECDSASignature)new ECDSASignature(new BigInteger(1, sd.getR()), new BigInteger(1, sd.getS())), (byte[])msgHash);
            if (publicKey == null || !(addressRecovered = "0x" + Keys.getAddress((BigInteger)publicKey)).equals(address)) continue;
            match = true;
            break;
        }
        return match;
    }
}

