/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.tx;

import java.math.BigInteger;
import java.util.List;
import network.arkane.provider.tx.EthereumTxLog;
import network.arkane.provider.tx.TxInfo;
import network.arkane.provider.tx.TxStatus;

public class EthereumTxInfo
extends TxInfo {
    private BigInteger nonce;
    private BigInteger gas;
    private BigInteger gasUsed;
    private BigInteger gasPrice;
    private List<EthereumTxLog> logs;
    private String from;
    private String to;

    protected EthereumTxInfo() {
    }

    public EthereumTxInfo(String hash, TxStatus status, String from, String to, BigInteger confirmations, String blockHash, BigInteger blockNumber, BigInteger nonce, BigInteger gas, BigInteger gasUsed, BigInteger gasPrice, List<EthereumTxLog> logs) {
        super(hash, status, confirmations, blockHash, blockNumber);
        this.nonce = nonce;
        this.gas = gas;
        this.gasUsed = gasUsed;
        this.gasPrice = gasPrice;
        this.logs = logs;
        this.from = from;
        this.to = to;
    }

    public static EthereumTxInfoBuilder ethereumTxInfoBuilder() {
        return new EthereumTxInfoBuilder();
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public List<EthereumTxLog> getLogs() {
        return this.logs;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String toString() {
        return "EthereumTxInfo(nonce=" + this.getNonce() + ", gas=" + this.getGas() + ", gasUsed=" + this.getGasUsed() + ", gasPrice=" + this.getGasPrice() + ", logs=" + this.getLogs() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public static class EthereumTxInfoBuilder {
        private String hash;
        private TxStatus status;
        private String from;
        private String to;
        private BigInteger confirmations;
        private String blockHash;
        private BigInteger blockNumber;
        private BigInteger nonce;
        private BigInteger gas;
        private BigInteger gasUsed;
        private BigInteger gasPrice;
        private List<EthereumTxLog> logs;

        EthereumTxInfoBuilder() {
        }

        public EthereumTxInfoBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public EthereumTxInfoBuilder status(TxStatus status) {
            this.status = status;
            return this;
        }

        public EthereumTxInfoBuilder from(String from) {
            this.from = from;
            return this;
        }

        public EthereumTxInfoBuilder to(String to) {
            this.to = to;
            return this;
        }

        public EthereumTxInfoBuilder confirmations(BigInteger confirmations) {
            this.confirmations = confirmations;
            return this;
        }

        public EthereumTxInfoBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public EthereumTxInfoBuilder blockNumber(BigInteger blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public EthereumTxInfoBuilder nonce(BigInteger nonce) {
            this.nonce = nonce;
            return this;
        }

        public EthereumTxInfoBuilder gas(BigInteger gas) {
            this.gas = gas;
            return this;
        }

        public EthereumTxInfoBuilder gasUsed(BigInteger gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public EthereumTxInfoBuilder gasPrice(BigInteger gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public EthereumTxInfoBuilder logs(List<EthereumTxLog> logs) {
            this.logs = logs;
            return this;
        }

        public EthereumTxInfo build() {
            return new EthereumTxInfo(this.hash, this.status, this.from, this.to, this.confirmations, this.blockHash, this.blockNumber, this.nonce, this.gas, this.gasUsed, this.gasPrice, this.logs);
        }

        public String toString() {
            return "EthereumTxInfo.EthereumTxInfoBuilder(hash=" + this.hash + ", status=" + this.status + ", from=" + this.from + ", to=" + this.to + ", confirmations=" + this.confirmations + ", blockHash=" + this.blockHash + ", blockNumber=" + this.blockNumber + ", nonce=" + this.nonce + ", gas=" + this.gas + ", gasUsed=" + this.gasUsed + ", gasPrice=" + this.gasPrice + ", logs=" + this.logs + ")";
        }
    }
}

