/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.nonfungable;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import network.arkane.provider.nonfungable.OpenSeaContractToNonFungibleContractMapper;
import network.arkane.provider.nonfungible.domain.NonFungibleAsset;
import network.arkane.provider.opensea.domain.Asset;
import org.springframework.stereotype.Component;

@Component
public class OpenSeaAssetToNonFungibleAssetMapper {
    private final OpenSeaContractToNonFungibleContractMapper contractMapper;

    public OpenSeaAssetToNonFungibleAssetMapper(OpenSeaContractToNonFungibleContractMapper contractMapper) {
        this.contractMapper = contractMapper;
    }

    public NonFungibleAsset map(Asset openSeaAsset) {
        if (openSeaAsset == null) {
            return null;
        }
        return NonFungibleAsset.builder().tokenId(openSeaAsset.getTokenId()).name(openSeaAsset.getName()).backgroundColor(openSeaAsset.getBackgroundColor()).description(openSeaAsset.getDescription()).imageUrl(openSeaAsset.getImageUrl()).imagePreviewUrl(openSeaAsset.getImagePreviewUrl()).imageThumbnailUrl(openSeaAsset.getImageThumbnailUrl()).url(openSeaAsset.getExternalLink()).owner(openSeaAsset.getOwner() != null ? openSeaAsset.getOwner().getAddress() : null).contract(this.contractMapper.map(openSeaAsset.getAssetContract())).build();
    }

    public List<NonFungibleAsset> mapToList(Collection<? extends Asset> openSeaAssets) {
        return openSeaAssets.stream().map(this::map).collect(Collectors.toList());
    }
}

