/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.wallet.generation;

import network.arkane.provider.JSONUtil;
import network.arkane.provider.wallet.generation.GeneratedWallet;
import org.apache.commons.codec.binary.Base64;
import org.web3j.crypto.WalletFile;

public class GeneratedEthereumWallet
implements GeneratedWallet {
    private String address;
    private WalletFile walletFile;

    public String getAddress() {
        return this.address;
    }

    public String secretAsBase64() {
        return Base64.encodeBase64String((byte[])JSONUtil.toJson((Object)this.walletFile).getBytes());
    }

    GeneratedEthereumWallet(String address, WalletFile walletFile) {
        this.address = address;
        this.walletFile = walletFile;
    }

    public static GeneratedEthereumWalletBuilder builder() {
        return new GeneratedEthereumWalletBuilder();
    }

    public WalletFile getWalletFile() {
        return this.walletFile;
    }

    public static class GeneratedEthereumWalletBuilder {
        private String address;
        private WalletFile walletFile;

        GeneratedEthereumWalletBuilder() {
        }

        public GeneratedEthereumWalletBuilder address(String address) {
            this.address = address;
            return this;
        }

        public GeneratedEthereumWalletBuilder walletFile(WalletFile walletFile) {
            this.walletFile = walletFile;
            return this;
        }

        public GeneratedEthereumWallet build() {
            return new GeneratedEthereumWallet(this.address, this.walletFile);
        }

        public String toString() {
            return "GeneratedEthereumWallet.GeneratedEthereumWalletBuilder(address=" + this.address + ", walletFile=" + this.walletFile + ")";
        }
    }
}

