/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.nio.charset.StandardCharsets;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.sign.EthereumRawSignable;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.domain.HexSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;

@Component
public class EthereumRawSigner
implements Signer<EthereumRawSignable, EthereumSecretKey> {
    private static final Logger log = LoggerFactory.getLogger(EthereumRawSigner.class);

    public HexSignature createSignature(EthereumRawSignable signable, EthereumSecretKey key) {
        try {
            Sign.SignatureData signatureData = Sign.signPrefixedMessage((byte[])signable.getData().getBytes(StandardCharsets.UTF_8), (ECKeyPair)key.getKeyPair());
            return HexSignature.builder().r(signatureData.getR()).s(signatureData.getS()).v((int)signatureData.getV()).build();
        }
        catch (Exception ex) {
            log.error("Unable to sign transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.sign.internal-error").errorCode("A problem occurred trying to sign the raw Ethereum object").cause((Throwable)ex).build();
        }
    }
}

