/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.math.BigInteger;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.Prefix;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.sign.EthereumTransactionSignable;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.domain.Signature;
import network.arkane.provider.sign.domain.TransactionSignature;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.stereotype.Component;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;

@Component
public class EthereumTransactionSigner
implements Signer<EthereumTransactionSignable, EthereumSecretKey> {
    private static final String DEFAULT_DATA = "0x";

    public Signature createSignature(EthereumTransactionSignable signable, EthereumSecretKey key) {
        RawTransaction rawTransaction = this.constructTransaction(signable);
        byte[] encodedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)Credentials.create((ECKeyPair)key.getKeyPair()));
        String prettify = BytesUtils.withHexPrefix((String)Hex.toHexString((byte[])encodedMessage), (Prefix)Prefix.ZeroLowerX);
        return TransactionSignature.signTransactionBuilder().signedTransaction(prettify).build();
    }

    private RawTransaction constructTransaction(EthereumTransactionSignable signTransactionRequest) {
        return RawTransaction.createTransaction((BigInteger)signTransactionRequest.getNonce(), (BigInteger)signTransactionRequest.getGasPrice(), (BigInteger)signTransactionRequest.getGasLimit(), (String)signTransactionRequest.getTo(), (BigInteger)signTransactionRequest.getValue(), (String)(StringUtils.isBlank((CharSequence)signTransactionRequest.getData()) ? DEFAULT_DATA : signTransactionRequest.getData()));
    }
}

