/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.secret.generation;

import network.arkane.provider.chain.SecretType;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.secret.generation.SecretGenerator;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;

@Component
public class EthereumSecretGenerator
implements SecretGenerator<EthereumSecretKey> {
    public EthereumSecretKey generate() {
        try {
            ECKeyPair ecKeyPair = Keys.createEcKeyPair();
            return EthereumSecretKey.builder().keyPair(ecKeyPair).build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to generate ethereum keypair");
        }
    }

    public SecretType type() {
        return SecretType.ETHEREUM;
    }
}

