/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.nio.charset.StandardCharsets;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.secret.generation.EthereumSecretKey;
import network.arkane.provider.sign.EthereumRawSignable;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.domain.HexSignature;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;

@Component
public class EthereumRawSigner
implements Signer<EthereumRawSignable, EthereumSecretKey> {
    private static final Logger log = LoggerFactory.getLogger(EthereumRawSigner.class);

    public HexSignature createSignature(EthereumRawSignable signable, EthereumSecretKey key) {
        try {
            byte[] dataToSign;
            log.debug("Signing raw ethereum transaction: {}", (Object)signable.toString());
            if (signable.getData() != null && this.isHexadecimal(signable.getData())) {
                try {
                    dataToSign = Hex.decodeHex((String)signable.getData().replaceFirst("0x", ""));
                }
                catch (DecoderException de) {
                    dataToSign = signable.getData().getBytes(StandardCharsets.UTF_8);
                }
            } else {
                byte[] byArray = dataToSign = signable.getData() == null ? "".getBytes(StandardCharsets.UTF_8) : signable.getData().getBytes(StandardCharsets.UTF_8);
            }
            Sign.SignatureData signatureData = signable.isPrefix() ? Sign.signPrefixedMessage((byte[])dataToSign, (ECKeyPair)key.getKeyPair()) : (signable.isHash() ? Sign.signMessage((byte[])dataToSign, (ECKeyPair)key.getKeyPair()) : Sign.signMessage((byte[])dataToSign, (ECKeyPair)key.getKeyPair(), (boolean)false));
            return HexSignature.builder().r(signatureData.getR()).s(signatureData.getS()).v((int)signatureData.getV()).build();
        }
        catch (Exception ex) {
            log.error("Unable to sign transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.sign.internal-error").cause((Throwable)ex).build();
        }
    }
}

