/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.contract;

import java.io.IOException;
import java.util.List;
import network.arkane.provider.contract.ContractService;
import network.arkane.provider.contract.EvmContractService;
import network.arkane.provider.gateway.EthereumWeb3JGateway;
import org.springframework.stereotype.Component;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;

@Component
public class EthereumContractService
extends EvmContractService
implements ContractService {
    private EthereumWeb3JGateway ethereumWeb3JGateway;

    public EthereumContractService(EthereumWeb3JGateway ethereumWeb3JGateway) {
        this.ethereumWeb3JGateway = ethereumWeb3JGateway;
    }

    List<Type> executeContractCall(String from, String to, Function function) {
        String data = FunctionEncoder.encode((Function)function);
        EthCall ethCall = null;
        try {
            ethCall = (EthCall)this.ethereumWeb3JGateway.web3().ethCall(Transaction.createEthCallTransaction((String)from, (String)to, (String)data), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }
}

