/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import network.arkane.provider.gateway.EthereumWeb3JGateway;
import network.arkane.provider.gateway.EthereumWeb3JGatewayFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketService;

@Configuration
@EnableScheduling
public class Web3AutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Web3AutoConfiguration.class);
    private WebSocketClient websocket;

    @Scheduled(fixedDelay=10000L)
    public void assureConnection() {
        if (this.websocket != null && !this.websocket.isOpen()) {
            try {
                this.websocket.reconnect();
            }
            catch (Exception ex) {
                log.error("Unable to reconnect to arkane ws {}", (Object)ex.getMessage());
            }
        }
    }

    @Primary
    @Bean(name={"ethereumWeb3j"})
    public Web3j ethereumWeb3j(@Value(value="${network.arkane.ethereum.endpoint.url}") String endpoint) {
        if (endpoint.startsWith("ws")) {
            this.websocket = new WebSocketClient(URI.create(endpoint));
            return Web3j.build((Web3jService)new WebSocketService(this.websocket, false));
        }
        return Web3j.build((Web3jService)new HttpService(endpoint, this.createOkHttpClient(), false));
    }

    private OkHttpClient createOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Web3AutoConfiguration.configureLogging(builder);
        this.configureTimeouts(builder);
        return builder.build();
    }

    private void configureTimeouts(OkHttpClient.Builder builder) {
        long tos = 60L;
        builder.connectTimeout(tos, TimeUnit.SECONDS);
        builder.readTimeout(tos, TimeUnit.SECONDS);
        builder.writeTimeout(tos, TimeUnit.SECONDS);
    }

    private static void configureLogging(OkHttpClient.Builder builder) {
        if (log.isDebugEnabled()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)log).error(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
    }

    @Bean
    public EthereumWeb3JGateway ethereumWeb3JGateway(EthereumWeb3JGatewayFactory ethereumWeb3JGatewayFactory) {
        return ethereumWeb3JGatewayFactory.getInstance();
    }
}

